/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class McBrydeS2
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "McBryde S2";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double JOIN_LAT = 49.2666666667;
    private static final double YSHIFT = 0.084398;
    private static final double TWO_PLUS_PI = 5.141592653589793;
    private static final double TERM1 = Math.sqrt(5.141592653589793);
    private static final double ONE_OVER_TERM1 = 1.0 / TERM1;
    private static final double TERM2 = 2.0 * ONE_OVER_TERM1;
    private static final double TERM3 = 0.5 * TERM2 * TERM2;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = ONE_OVER_TERM1 * Math.PI - 0.084398;
    private static final double ASPECT_RATIO = Math.PI / HEIGHT_FACTOR;

    public McBrydeS2(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public McBrydeS2(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public McBrydeS2(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, Math.PI, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        Point2D.Double joinPt = this.transformLL2XY(0.0, 49.2666666667);
        double joinY = (double)this.dstCenter.y - joinPt.y;
        double twoOverRS = 2.0 * this.oneOverRS;
        for (int iy = 0; iy < this.dstMax.y; ++iy) {
            double x;
            double lambda;
            double xFactor;
            double phi;
            double y = (double)iy + 0.5;
            if (y > joinY) {
                double thetaRad = (y += 0.084398 * this.rS) * this.oneOverRS / TERM2;
                double sinTheta = Math.sin(thetaRad);
                phi = McBrydeS2.toDegrees(Math.asin((thetaRad + sinTheta) * TERM3));
                xFactor = twoOverRS / (TERM2 * (1.0 + Math.cos(thetaRad)));
            } else {
                double phiRad = y * this.oneOverRS;
                phi = McBrydeS2.toDegrees(phiRad);
                xFactor = this.oneOverRS / Math.cos(phiRad);
            }
            if (phi > 90.0) break;
            for (int ix = 0; ix < this.dstMax.x && !((lambda = McBrydeS2.toDegrees((x = (double)ix + 0.5) * xFactor)) > 180.0); ++ix) {
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double x = this.transformLon2LambdaRad(lon);
        double y = 1.0;
        if (Math.abs(lat) > 49.2666666667) {
            double phiFactor = 2.5707963267948966 * Math.sin(McBrydeS2.toRadians(lat));
            double thetaRad = McBrydeS2.toRadians(lat);
            for (int i = 0; i < 25; ++i) {
                double sinTheta = Math.sin(thetaRad);
                double cosTheta = Math.cos(thetaRad);
                double dthetaRad = -(thetaRad + sinTheta - phiFactor) / (1.0 + cosTheta);
                thetaRad += dthetaRad;
                if (Math.abs(dthetaRad) < 1.0E-5) break;
            }
            x *= (1.0 + Math.cos(thetaRad)) * ONE_OVER_TERM1;
            y = lat > 0.0 ? (y *= 2.0 * thetaRad * ONE_OVER_TERM1 - 0.084398) : (y *= 2.0 * thetaRad * ONE_OVER_TERM1 + 0.084398);
        } else {
            double phiRad = McBrydeS2.toRadians(lat);
            x *= Math.cos(phiRad);
            y *= phiRad;
        }
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

