/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class McBrydeQ3
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "McBryde Q3";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double JOIN_LAT = 52.15;
    private static final double YSHIFT = 0.042686;
    private static final double TWO_PLUS_SQRT2 = 2.0 + SQRT2;
    private static final double HALF_TWO_PLUS_SQRT2 = 0.5 * TWO_PLUS_SQRT2;
    private static final double FPQTERM1 = 2.0 * Math.sqrt(3.0 / TWO_PLUS_SQRT2);
    private static final double FPQTERM2 = Math.sqrt(6.0 + 3.0 * SQRT2);
    private static final double ONE_OVER_FPQTERM1 = 1.0 / FPQTERM1;
    private static final double ONE_OVER_FPQTERM2 = 1.0 / FPQTERM2;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = FPQTERM1 / SQRT2 - 0.042686;
    private static final double ASPECT_RATIO = Math.PI / HEIGHT_FACTOR;

    public McBrydeQ3(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public McBrydeQ3(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public McBrydeQ3(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, Math.PI, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        Point2D.Double joinPt = this.transformLL2XY(0.0, 52.15);
        double joinY = (double)this.dstCenter.y - joinPt.y;
        double oneOver2RS = 0.5 * this.oneOverRS;
        for (int iy = 0; iy < this.dstMax.y; ++iy) {
            double x;
            double lambda;
            double xFactor;
            double phi;
            double y = (double)iy + 0.5;
            if (y > joinY) {
                double thetaRad = 2.0 * Math.asin((y += 0.042686 * this.rS) * this.oneOverRS * ONE_OVER_FPQTERM1);
                phi = McBrydeQ3.toDegrees(Math.asin(2.0 * (Math.sin(thetaRad) + Math.sin(0.5 * thetaRad)) / TWO_PLUS_SQRT2));
                xFactor = this.oneOverRS * FPQTERM2 / (1.0 + 2.0 * Math.cos(thetaRad) / Math.cos(0.5 * thetaRad));
            } else {
                double phiRad = 2.0 * Math.asin(y * oneOver2RS);
                phi = McBrydeQ3.toDegrees(phiRad);
                xFactor = this.oneOverRS * Math.cos(0.5 * phiRad) / Math.cos(phiRad);
            }
            if (phi > 90.0) break;
            for (int ix = 0; ix < this.dstMax.x && !((lambda = McBrydeQ3.toDegrees((x = (double)ix + 0.5) * xFactor)) > 180.0); ++ix) {
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double x = this.transformLon2LambdaRad(lon);
        double y = 1.0;
        if (Math.abs(lat) > 52.15) {
            double phiTerm = HALF_TWO_PLUS_SQRT2 * Math.sin(McBrydeQ3.toRadians(lat));
            double thetaRad = McBrydeQ3.toRadians(lat);
            for (int i = 0; i < 25; ++i) {
                double dthetaRad = -(Math.sin(0.5 * thetaRad) + Math.sin(thetaRad) - phiTerm) / (0.5 * Math.cos(0.5 * thetaRad) + Math.cos(thetaRad));
                thetaRad += dthetaRad;
                if (Math.abs(dthetaRad) < 1.0E-5) break;
            }
            x *= (1.0 + 2.0 * Math.cos(thetaRad) / Math.cos(0.5 * thetaRad)) * ONE_OVER_FPQTERM2;
            y = lat > 0.0 ? (y *= FPQTERM1 * Math.sin(0.5 * thetaRad) - 0.042686) : (y *= FPQTERM1 * Math.sin(0.5 * thetaRad) + 0.042686);
        } else {
            double phiRad = McBrydeQ3.toRadians(lat);
            x *= Math.cos(phiRad) / Math.cos(0.5 * phiRad);
            y *= 2.0 * Math.sin(0.5 * phiRad);
        }
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

