/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class McBrydeP3
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "McBryde P3";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double JOIN_LAT = 49.3393888889;
    private static final double YSHIFT = 0.035509;
    private static final double SQRT3PI = Math.sqrt(Math.PI * 3);
    private static final double SQRT3OVERPI = Math.sqrt(0.954929658551372);
    private static final double SQRT_PIOVER3 = Math.sqrt(1.0471975511965976);
    private static final double THREE_SQRT6 = 3.0 * Math.sqrt(6.0);
    private static final double SQRT_6OVER7 = Math.sqrt(0.8571428571428571);
    private static final double SQRT_7OVER6 = 1.0 / SQRT_6OVER7;
    private static final double NINE_OVER_SQRT7 = 9.0 / Math.sqrt(7.0);
    private static final double WIDTH_FACTOR = SQRT3PI;
    private static final double HEIGHT_FACTOR = NINE_OVER_SQRT7 * Math.sin(Math.asin(7.0 / THREE_SQRT6) / 3.0) - 0.035509;
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public McBrydeP3(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public McBrydeP3(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public McBrydeP3(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        Point2D.Double joinPt = this.transformLL2XY(0.0, 49.3393888889);
        double joinY = (double)this.dstCenter.y - joinPt.y;
        double rSSqrt3OverPi = this.rS * SQRT3OVERPI;
        double oneOverRSSqrt3Pi = 1.0 / (this.rS * SQRT3PI);
        for (int iy = 0; iy < this.dstMax.y; ++iy) {
            double x;
            double lambda;
            double xFactor;
            double phi;
            double phiRad;
            double y = (double)iy + 0.5;
            if (y > joinY) {
                double thetaRad = 3.0 * Math.asin((y += 0.035509 * this.rS) * this.oneOverRS / NINE_OVER_SQRT7);
                double sinTheta = Math.sin(thetaRad);
                phiRad = Math.asin(sinTheta * THREE_SQRT6 / 7.0);
                phi = McBrydeP3.toDegrees(phiRad);
                xFactor = this.oneOverRS * SQRT_7OVER6 / (2.0 * Math.cos(thetaRad * 2.0 / 3.0) - 1.0);
            } else {
                phiRad = 3.0 * Math.asin(y * oneOverRSSqrt3Pi);
                phi = McBrydeP3.toDegrees(phiRad);
                xFactor = 1.0 / (rSSqrt3OverPi * (2.0 * Math.cos(2.0 * phiRad / 3.0) - 1.0));
            }
            if (phi > 90.0) break;
            for (int ix = 0; ix < this.dstMax.x && !((lambda = McBrydeP3.toDegrees((x = (double)ix + 0.5) * xFactor)) > 180.0); ++ix) {
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double x = this.transformLon2LambdaRad(lon);
        double y = 1.0;
        if (Math.abs(lat) > 49.3393888889) {
            double thetaRad = Math.asin(7.0 * Math.sin(McBrydeP3.toRadians(lat)) / THREE_SQRT6);
            x *= SQRT_6OVER7 * (2.0 * Math.cos(thetaRad * 2.0 / 3.0) - 1.0);
            y = lat > 0.0 ? (y *= NINE_OVER_SQRT7 * Math.sin(thetaRad / 3.0) - 0.035509) : (y *= NINE_OVER_SQRT7 * Math.sin(thetaRad / 3.0) + 0.035509);
        } else {
            double phiRadOver3 = McBrydeP3.toRadians(lat) / 3.0;
            x *= SQRT3OVERPI * (2.0 * Math.cos(2.0 * phiRadOver3) - 1.0);
            y *= SQRT3PI * Math.sin(phiRadOver3);
        }
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

