/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class Kavraisky7
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Kavraisky VII";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double CSUBX = 0.5 * SQRT3;
    private static final double ONE_OVER_CSUBX = 1.0 / CSUBX;
    private static final double THREE_OVER_PI2 = 0.3039635509270133;
    private static final double WIDTH_FACTOR = CSUBX * Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double ASPECT_RATIO = WIDTH_FACTOR / 1.5707963267948966;

    public Kavraisky7(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Kavraisky7(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Kavraisky7(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, 1.5707963267948966, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRS) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Kavraisky7.toDegrees(phiRad);
            double xFactor = ONE_OVER_CSUBX * this.oneOverRS / Math.sqrt(1.0 - phiRad * phiRad * 0.3039635509270133);
            for (int ix = 0; ix < this.dstMax.x && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Kavraisky7.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Kavraisky7.toRadians(lat);
        double x = CSUBX * this.transformLon2LambdaRad(lon) * Math.sqrt(1.0 - phiRad * phiRad * 0.3039635509270133);
        double y = phiRad;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

