/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.PointPoleProjection;
import java.awt.geom.Point2D;

public class Kavraisky5
extends PointPoleProjection {
    private static final String PROJECTION_NAME = "Kavraisky V";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERM_Q = Kavraisky5.toRadians(35.0) / Math.acos(0.9);
    private static final double Q_OVER_P = 0.9;
    private static final double P_OVER_Q = 1.1111111111111112;
    private static final double TERM_P = TERM_Q * 1.1111111111111112;
    private static final double WIDTH_FACTOR = 2.827433388230814;
    private static final double HEIGHT_FACTOR = TERM_P * Math.sin(1.5707963267948966 / TERM_Q);
    private static final double ASPECT_RATIO = 2.827433388230814 / HEIGHT_FACTOR;

    public Kavraisky5(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Kavraisky5(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Kavraisky5(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, 2.827433388230814, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        double phi;
        this.clearInverseArray();
        double oneOverPRS = this.oneOverRS / TERM_P;
        for (int iy = 0; iy < this.dstMax.y && !((phi = Kavraisky5.toDegrees(phiRad = TERM_Q * Math.asin((y = (double)iy + 0.5) * oneOverPRS))) > 90.0); ++iy) {
            double x;
            double lambda;
            double xFactor = this.oneOverRS * 1.1111111111111112 * Math.cos(phiRad / TERM_Q) / Math.cos(phiRad);
            for (int ix = 0; ix < this.dstMax.x && !((lambda = Kavraisky5.toDegrees((x = (double)ix + 0.5) * xFactor)) > 180.0); ++ix) {
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Kavraisky5.toRadians(lat);
        double phiOverQ = phiRad / TERM_Q;
        double x = 0.9 * this.transformLon2LambdaRad(lon) * Math.cos(phiRad) / Math.cos(phiOverQ);
        double y = TERM_P * Math.sin(phiOverQ);
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

