/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class Holzel
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "H\u00f6lzel";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double CONST_A = 0.322673;
    private static final double CONST_B = 0.369722;
    private static final double CONST_C = 0.40928;
    private static final double CONST_D = 1.161517;
    private static final double CONST_E = 0.441013;
    private static final double WIDTH_FACTOR = 2.770966401875191;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double ASPECT_RATIO = 1.764052;

    public Holzel(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Holzel(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Holzel(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, 2.770966401875191, 1.5707963267948966, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 1.764052;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        double phi;
        this.clearInverseArray();
        double oneOver2RS = 0.5 * this.oneOverRS;
        for (int iy = 0; iy < this.dstMax.y && !((phi = Holzel.toDegrees(phiRad = (y = (double)iy + 0.5) * this.oneOverRS)) > 90.0); ++iy) {
            double x;
            double lambdaRad;
            double xFactor = this.oneOverRS;
            if (phi > 80.0) {
                double a = (phiRad - 0.40928) / 1.161517;
                xFactor /= 0.322673 + 0.369722 * Math.sqrt(1.0 - a * a);
            } else {
                xFactor /= 0.441013 * (1.0 + Math.cos(phiRad));
            }
            for (int ix = 0; ix < this.dstMax.x && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Holzel.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Holzel.toRadians(lat);
        double x = this.transformLon2LambdaRad(lon);
        if (Math.abs(lat) > 80.0) {
            double a = Math.max(0.0, (Math.abs(phiRad) - 0.40928) / 1.161517);
            x *= 0.322673 + 0.369722 * Math.sqrt(1.0 - a * a);
        } else {
            x *= 0.441013 * (1.0 + Math.cos(phiRad));
        }
        double y = phiRad;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

