/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.EllipseProjection;
import java.awt.geom.Point2D;

public class Hammer
extends EllipseProjection {
    private static final String PROJECTION_NAME = "Hammer";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double WIDTH_FACTOR = 2.0 * SQRT2;
    private static final double HEIGHT_FACTOR = SQRT2;
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public Hammer(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Hammer(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Hammer(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        double oneOver2RS = 0.5 * this.oneOverRS;
        double oneOverRS2 = this.oneOverRS * this.oneOverRS;
        block0: for (int iy = 0; iy < this.dstMax.y; ++iy) {
            double y = (double)iy + 0.5;
            double y2 = y * y;
            for (int ix = 0; ix < this.dstMax.x; ++ix) {
                double lambdaRad;
                double x = (double)ix + 0.5;
                double d2 = (0.25 * x * x + y2) * oneOverRS2;
                double beta = Math.acos(1.0 - 0.5 * d2);
                double cosHalfBeta = Math.cos(0.5 * beta);
                double phiRad = Math.asin(y * cosHalfBeta * this.oneOverRS);
                if (phiRad < 1.5707963267948966) {
                    lambdaRad = 2.0 * Math.atan2(x * cosHalfBeta * oneOver2RS, Math.cos(beta));
                } else {
                    if (phiRad > 1.5707963267948966) continue block0;
                    lambdaRad = 0.0;
                }
                if (lambdaRad > Math.PI) continue block0;
                this.setQSymmetricPoints(ix, iy, Hammer.toDegrees(lambdaRad), Hammer.toDegrees(phiRad));
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double halfLambdaRad = 0.5 * this.transformLon2LambdaRad(lon);
        double cosLat = Math.cos(Hammer.toRadians(lat));
        double sinLat = Math.sin(Hammer.toRadians(lat));
        double k = Math.sqrt(2.0 / (1.0 + cosLat * Math.cos(halfLambdaRad)));
        double x = 2.0 * k * cosLat * Math.sin(halfLambdaRad);
        double y = k * sinLat;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

