/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.CurvePoleProjection;
import java.awt.geom.Point2D;

public class GoodeHomolosine
extends CurvePoleProjection {
    private static final String PROJECTION_NAME = "Goode Homolosine";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double JOIN_LAT = 40.7333333333;
    private static final double YSHIFT = 0.0528;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = SQRT2 - 0.0528;
    private static final double ASPECT_RATIO = Math.PI / HEIGHT_FACTOR;

    public GoodeHomolosine(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public GoodeHomolosine(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public GoodeHomolosine(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, Math.PI, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        Point2D.Double joinPt = this.transformLL2XY(0.0, 40.7333333333);
        double joinY = (double)this.dstCenter.y - joinPt.y;
        double oneOverSqrt2RS = this.oneOverRS / SQRT2;
        for (int iy = 0; iy < this.dstMax.y; ++iy) {
            double x;
            double lambda;
            double xFactor;
            double phi;
            double phiRad;
            double y = (double)iy + 0.5;
            if (y > joinY) {
                double thetaRad = Math.asin((y += 0.0528 * this.rS) * oneOverSqrt2RS);
                phiRad = Math.asin((2.0 * thetaRad + Math.sin(2.0 * thetaRad)) * 0.3183098861837907);
                phi = GoodeHomolosine.toDegrees(phiRad);
                xFactor = 1.5707963267948966 * this.oneOverRS / (SQRT2 * Math.cos(thetaRad));
            } else {
                phiRad = y * this.oneOverRS;
                phi = GoodeHomolosine.toDegrees(phiRad);
                xFactor = this.oneOverRS / Math.cos(phiRad);
            }
            if (phi > 90.0) break;
            for (int ix = 0; ix < this.dstMax.x && !((lambda = GoodeHomolosine.toDegrees((x = (double)ix + 0.5) * xFactor)) > 180.0); ++ix) {
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        if (lat == 90.0) {
            return new Point2D.Double(this.dstCenter.x, (double)this.dstCenter.y - (SQRT2 - 0.0528) * this.rS);
        }
        if (lat == -90.0) {
            return new Point2D.Double(this.dstCenter.x, (double)this.dstCenter.y + (SQRT2 - 0.0528) * this.rS);
        }
        double x = this.transformLon2LambdaRad(lon);
        double y = 1.0;
        if (Math.abs(lat) > 40.7333333333) {
            double piSinPhi = Math.PI * Math.sin(GoodeHomolosine.toRadians(lat));
            double thetaRad = GoodeHomolosine.toRadians(lat);
            for (int i = 0; i < 25; ++i) {
                double twoThetaRad = 2.0 * thetaRad;
                double dthetaRad = 0.5 * (piSinPhi - twoThetaRad - Math.sin(twoThetaRad)) / (1.0 + Math.cos(twoThetaRad));
                thetaRad += dthetaRad;
                if (Math.abs(dthetaRad) < 1.0E-5) break;
            }
            x *= SQRT2 * Math.cos(thetaRad) / 1.5707963267948966;
            y = lat > 0.0 ? (y *= SQRT2 * Math.sin(thetaRad) - 0.0528) : (y *= SQRT2 * Math.sin(thetaRad) + 0.0528);
        } else {
            double phiRad = GoodeHomolosine.toRadians(lat);
            x *= Math.cos(phiRad);
            y *= phiRad;
        }
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

