/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.RectangleProjection;
import java.awt.geom.Point2D;

public class Gall
extends RectangleProjection {
    private static final String PROJECTION_NAME = "Gall";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TWO_PLUS_SQRT2 = 2.0 + SQRT2;
    private static final double TERM2 = 0.5 * TWO_PLUS_SQRT2;
    private static final double TERM3 = 2.0 / TWO_PLUS_SQRT2;
    private static final double WIDTH_FACTOR = Math.PI / SQRT2;
    private static final double HEIGHT_FACTOR = TERM2 * Math.tan(Gall.toRadians(45.0));
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public Gall(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Gall(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Gall(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        this.clearInverseArray();
        double sqrt2OverRS = SQRT2 * this.oneOverRS;
        double term3OverRS = TERM3 * this.oneOverRS;
        for (int iy = 0; iy < this.dstMax.y && !((phiRad = 2.0 * Math.atan((y = (double)iy + 0.5) * term3OverRS)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Gall.toDegrees(phiRad);
            for (int ix = 0; ix < this.dstMax.x && !((lambdaRad = (x = (double)ix + 0.5) * sqrt2OverRS) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Gall.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double x = this.transformLon2LambdaRad(lon) / SQRT2;
        double y = TERM2 * Math.tan(0.5 * Gall.toRadians(lat));
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

