/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.PointPoleProjection;
import java.awt.geom.Point2D;

public class Foucaut
extends PointPoleProjection {
    private static final String PROJECTION_NAME = "Foucaut";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERM_P = SQRT_PI;
    private static final double TERM_Q = 2.0;
    private static final double Q_OVER_P = 2.0 / TERM_P;
    private static final double P_OVER_Q = 1.0 / Q_OVER_P;
    private static final double WIDTH_FACTOR = Q_OVER_P * Math.PI;
    private static final double HEIGHT_FACTOR = TERM_P * Math.tan(0.7853981633974483);
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public Foucaut(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Foucaut(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Foucaut(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        double phi;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phi = Foucaut.toDegrees(phiRad = 2.0 * Math.atan((y = (double)iy + 0.5) * this.oneOverRS / TERM_P))) > 90.0); ++iy) {
            double x;
            double lambda;
            double xFactor;
            if (phi < 90.0) {
                double phiOverQ = phiRad / 2.0;
                double cosPhiOverQ = Math.cos(phiOverQ);
                xFactor = this.oneOverRS * P_OVER_Q / Math.cos(phiRad) / (cosPhiOverQ * cosPhiOverQ);
            } else {
                xFactor = 90.0;
            }
            for (int ix = 0; ix < this.dstMax.x && !((lambda = Foucaut.toDegrees((x = (double)ix + 0.5) * xFactor)) > 180.0) && !(lambda < -180.0); ++ix) {
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Foucaut.toRadians(lat);
        double phiOverQ = phiRad / 2.0;
        double cosPhiOverQ = Math.cos(phiOverQ);
        double x = Q_OVER_P * this.transformLon2LambdaRad(lon) * Math.cos(phiRad) * cosPhiOverQ * cosPhiOverQ;
        double y = TERM_P * Math.tan(phiOverQ);
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

