/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class FlatPolarSinusoidal
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "M.T. Flat-Polar Sinusoidal";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERM1 = Math.sqrt(1.1902654422649654);
    private static final double ONE_OVER_TERM1 = 1.0 / TERM1;
    private static final double TERM2 = 0.5600991535115574;
    private static final double ONE_OVER_TERM2 = 1.7853981633974483;
    private static final double WIDTH_FACTOR = Math.PI * ONE_OVER_TERM1;
    private static final double HEIGHT_FACTOR = 1.5707963267948966 * ONE_OVER_TERM1;
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public FlatPolarSinusoidal(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public FlatPolarSinusoidal(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public FlatPolarSinusoidal(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double sinTheta;
        double y;
        double thetaRad;
        double phi;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phi = FlatPolarSinusoidal.toDegrees(Math.asin((0.5 * (thetaRad = (y = (double)iy + 0.5) * this.oneOverRS * TERM1) + (sinTheta = Math.sin(thetaRad))) * 0.5600991535115574))) > 90.0); ++iy) {
            double x;
            double lambda;
            double xFactor = 1.5 * this.oneOverRS * TERM1 / (0.5 + Math.cos(thetaRad));
            for (int ix = 0; ix < this.dstMax.x && !((lambda = FlatPolarSinusoidal.toDegrees((x = (double)ix + 0.5) * xFactor)) > 180.0); ++ix) {
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiTerm = 1.7853981633974483 * Math.sin(FlatPolarSinusoidal.toRadians(lat));
        double thetaRad = FlatPolarSinusoidal.toRadians(lat);
        for (int i = 0; i < 25; ++i) {
            double sinTheta = Math.sin(thetaRad);
            double cosTheta = Math.cos(thetaRad);
            double dthetaRad = -(0.5 * thetaRad + sinTheta - phiTerm) / (0.5 + cosTheta);
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double x = this.transformLon2LambdaRad(lon) * ONE_OVER_TERM1 * (0.5 + Math.cos(thetaRad)) / 1.5;
        double y = thetaRad * ONE_OVER_TERM1;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

