/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class FlatPolarQuartic
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "M.T. Flat-Polar Quartic";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TWO_PLUS_SQRT2 = 2.0 + SQRT2;
    private static final double HALF_TWO_PLUS_SQRT2 = 0.5 * TWO_PLUS_SQRT2;
    private static final double TERM1 = 2.0 * Math.sqrt(3.0 / TWO_PLUS_SQRT2);
    private static final double TERM2 = Math.sqrt(6.0 + 3.0 * SQRT2);
    private static final double ONE_OVER_TERM1 = 1.0 / TERM1;
    private static final double ONE_OVER_TERM2 = 1.0 / TERM2;
    private static final double WIDTH_FACTOR = 1.5707963267948966 * TERM1;
    private static final double HEIGHT_FACTOR = TERM1 / SQRT2;
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public FlatPolarQuartic(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public FlatPolarQuartic(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public FlatPolarQuartic(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double thetaRad;
        double phiRad;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phiRad = Math.asin(2.0 * (Math.sin(thetaRad = 2.0 * Math.asin((y = (double)iy + 0.5) * this.oneOverRS * ONE_OVER_TERM1)) + Math.sin(0.5 * thetaRad)) / TWO_PLUS_SQRT2)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = FlatPolarQuartic.toDegrees(phiRad);
            double xFactor = this.oneOverRS * TERM2 / (1.0 + 2.0 * Math.cos(thetaRad) / Math.cos(0.5 * thetaRad));
            for (int ix = 0; ix < this.dstMax.x && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, FlatPolarQuartic.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiTerm = HALF_TWO_PLUS_SQRT2 * Math.sin(FlatPolarQuartic.toRadians(lat));
        double thetaRad = FlatPolarQuartic.toRadians(lat);
        for (int i = 0; i < 25; ++i) {
            double dthetaRad = -(Math.sin(0.5 * thetaRad) + Math.sin(thetaRad) - phiTerm) / (0.5 * Math.cos(0.5 * thetaRad) + Math.cos(thetaRad));
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double x = this.transformLon2LambdaRad(lon) * (1.0 + 2.0 * Math.cos(thetaRad) / Math.cos(0.5 * thetaRad)) * ONE_OVER_TERM2;
        double y = TERM1 * Math.sin(0.5 * thetaRad);
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

