/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class FlatPolarParabolic
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "M.T. Flat-Polar Parabolic";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERM1 = 3.0 * Math.sqrt(6.0);
    private static final double SQRT_6OVER7 = Math.sqrt(0.8571428571428571);
    private static final double SQRT_7OVER6 = 1.0 / SQRT_6OVER7;
    private static final double TERM3 = 9.0 / Math.sqrt(7.0);
    private static final double WIDTH_FACTOR = SQRT_6OVER7 * Math.PI;
    private static final double HEIGHT_FACTOR = TERM3 * Math.sin(Math.asin(7.0 / TERM1) / 3.0);
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public FlatPolarParabolic(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public FlatPolarParabolic(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public FlatPolarParabolic(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double thetaRad;
        double sinTheta;
        double phi;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phi = FlatPolarParabolic.toDegrees(Math.asin((sinTheta = Math.sin(thetaRad = 3.0 * Math.asin((y = (double)iy + 0.5) * this.oneOverRS / TERM3))) * TERM1 / 7.0))) > 90.0); ++iy) {
            double x;
            double lambda;
            double xFactor = this.oneOverRS * SQRT_7OVER6 / (2.0 * Math.cos(thetaRad * 2.0 / 3.0) - 1.0);
            for (int ix = 0; ix < this.dstMax.x && !((lambda = FlatPolarParabolic.toDegrees((x = (double)ix + 0.5) * xFactor)) > 180.0); ++ix) {
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double thetaRad = Math.asin(7.0 * Math.sin(FlatPolarParabolic.toRadians(lat)) / TERM1);
        double x = SQRT_6OVER7 * this.transformLon2LambdaRad(lon) * (2.0 * Math.cos(thetaRad * 2.0 / 3.0) - 1.0);
        double y = TERM3 * Math.sin(thetaRad / 3.0);
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

