/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.CurvePoleProjection;
import java.awt.geom.Point2D;

public class ErdiKrausz
extends CurvePoleProjection {
    private static final String PROJECTION_NAME = "\u00c9rdi-Krausz";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double JOIN_LAT = 60.0;
    private static final double YSHIFT = 0.28549;
    private static final double CXE = 0.96042;
    private static final double CXP = 1.07023;
    private static final double CYE = 1.30152;
    private static final double CYP = 1.68111;
    private static final double WIDTH_FACTOR = 3.0172484163607094;
    private static final double HEIGHT_FACTOR = 1.39562;
    private static final double ASPECT_RATIO = 2.1619412278132364;

    public ErdiKrausz(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public ErdiKrausz(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public ErdiKrausz(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, 3.0172484163607094, 1.39562, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 2.1619412278132364;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        Point2D.Double joinPt = this.transformLL2XY(0.0, 60.0);
        double joinY = (double)this.dstCenter.y - joinPt.y;
        for (int iy = 0; iy < this.dstMax.y; ++iy) {
            double x;
            double lambdaRad;
            double xFactor;
            double phiRad;
            double thetaRad;
            double y = (double)iy + 0.5;
            if (y > joinY) {
                double sinTheta = (y += 0.28549 * this.rS) * this.oneOverRS / 1.68111;
                thetaRad = Math.asin(sinTheta);
                phiRad = Math.asin((2.0 * thetaRad + Math.sin(2.0 * thetaRad)) / Math.PI);
                xFactor = this.oneOverRS / (1.07023 * Math.cos(thetaRad));
                if (phiRad > 1.5707963267948966) {
                    break;
                }
            } else {
                thetaRad = y * this.oneOverRS / 1.30152;
                phiRad = Math.asin(Math.sin(thetaRad) / 0.8);
                xFactor = this.oneOverRS / (0.96042 * Math.cos(thetaRad));
            }
            double phi = ErdiKrausz.toDegrees(phiRad);
            for (int ix = 0; ix < this.dstMax.x && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, ErdiKrausz.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        if (lat == 90.0) {
            return new Point2D.Double(this.dstCenter.x, (double)this.dstCenter.y - 1.39562 * this.rS);
        }
        if (lat == -90.0) {
            return new Point2D.Double(this.dstCenter.x, (double)this.dstCenter.y + 1.39562 * this.rS);
        }
        double x = this.transformLon2LambdaRad(lon);
        double y = 1.0;
        if (Math.abs(lat) > 60.0) {
            double phiTerm = Math.PI * Math.sin(ErdiKrausz.toRadians(lat));
            double thetaRad = ErdiKrausz.toRadians(lat);
            for (int i = 0; i < 25; ++i) {
                double dthetaRad = -(2.0 * thetaRad + Math.sin(2.0 * thetaRad) - phiTerm) / (2.0 + 2.0 * Math.cos(2.0 * thetaRad));
                thetaRad += dthetaRad;
                if (Math.abs(dthetaRad) < 1.0E-5) break;
            }
            x *= 1.07023 * Math.cos(thetaRad);
            y = lat > 0.0 ? (y *= 1.68111 * Math.sin(thetaRad) - 0.28549) : (y *= 1.68111 * Math.sin(thetaRad) + 0.28549);
        } else {
            double thetaRad = Math.asin(0.8 * Math.sin(ErdiKrausz.toRadians(lat)));
            x *= 0.96042 * Math.cos(thetaRad);
            y *= 1.30152 * thetaRad;
        }
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

