/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.ProjectionDoubleParameter;
import gov.nasa.giss.mapping.proj.ProjectionExtraParameter;
import gov.nasa.giss.mapping.proj.RectangleProjection;
import java.awt.geom.Point2D;

public class Equirectangular
extends RectangleProjection {
    private static final String PROJECTION_NAME = "Equirectangular";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double DEFAULT_PHITS = 0.0;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double ASPECT_RATIO = 2.0;
    private double cosPhiTS = Math.cos(0.0);
    private double trueWidth;
    private double halfTrueWidth;
    private int leftMargin;
    private int rightMargin;
    private int topMargin;
    private int bottomMargin;

    public Equirectangular(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Equirectangular(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, Math.PI, 1.5707963267948966, dw, dh, xm, ym);
        this.setExtraParameters(new ProjectionExtraParameter[]{new ProjectionDoubleParameter("Standard Parallel", "\u00b0", 0.0, 0.0, 90.0, true, false)});
        this.extraParameterChanged();
    }

    public void extraParameterChanged() {
        ProjectionDoubleParameter p = (ProjectionDoubleParameter)this.getParameter(1);
        this.cosPhiTS = Math.cos(Equirectangular.toRadians(p.getValue()));
        this.fitToTarget();
        this.needsUpdate = true;
    }

    protected void fitToTarget() {
        this.widthFactor = Math.PI * this.cosPhiTS;
        this.heightFactor = 1.5707963267948966;
        super.fitToTarget();
        this.trueWidth = (double)this.useSize.width * this.cosPhiTS;
        this.halfTrueWidth = 0.5 * this.trueWidth;
        this.leftMargin = (int)((double)this.dstCenter.x - this.halfTrueWidth);
        this.rightMargin = (int)((double)this.dstCenter.x + this.halfTrueWidth);
        this.topMargin = this.marginSize.height;
        this.bottomMargin = this.topMargin + this.useSize.height;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 2.0;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        this.clearInverseArray();
        double oneOverRSCosPhiTS = this.oneOverRS / this.cosPhiTS;
        for (int iy = 0; iy < this.dstMax.y && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRS) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            for (int ix = 0; ix < this.dstMax.x && !((lambdaRad = (x = (double)ix + 0.5) * oneOverRSCosPhiTS) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Equirectangular.toDegrees(lambdaRad), Equirectangular.toDegrees(phiRad));
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double x = this.cosPhiTS * this.transformLon2LambdaRad(lon);
        double y = -Equirectangular.toRadians(lat);
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y + y * this.rS);
    }
}

