/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.PointPoleProjection;
import java.awt.geom.Point2D;

public class EckertGreifendorff
extends PointPoleProjection {
    private static final String PROJECTION_NAME = "Eckert-Greifendorff";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double CW = 0.25;
    private static final double ONE_OVER_CW = 4.0;
    private static final double WIDTH_FACTOR = 4.0 * Math.sin(0.7853981633974483) * Math.sqrt(2.0 / (1.0 + Math.cos(0.7853981633974483)));
    private static final double HEIGHT_FACTOR = SQRT2;
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public EckertGreifendorff(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public EckertGreifendorff(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public EckertGreifendorff(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        double oneOver2RS = 0.5 * this.oneOverRS;
        block0: for (int iy = 0; iy < this.dstMax.y; ++iy) {
            double y = (double)iy + 0.5;
            double y2 = y * y;
            for (int ix = 0; ix < this.dstMax.x; ++ix) {
                double x = (double)ix + 0.5;
                double a = Math.sqrt(0.0625 * x * x + y2);
                double c = 2.0 * Math.asin(a * oneOver2RS);
                double sinC = Math.sin(c);
                double cosC = Math.cos(c);
                double phiRad = Math.asin(y * sinC / a);
                if (phiRad > 1.5707963267948966) continue block0;
                double lambdaRad = 4.0 * Math.atan2(0.25 * x * sinC, a * cosC);
                if (lambdaRad > Math.PI) continue;
                this.setQSymmetricPoints(ix, iy, EckertGreifendorff.toDegrees(lambdaRad), EckertGreifendorff.toDegrees(phiRad));
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double cwLambdaRad = 0.25 * this.transformLon2LambdaRad(lon);
        double cosLat = Math.cos(EckertGreifendorff.toRadians(lat));
        double sinLat = Math.sin(EckertGreifendorff.toRadians(lat));
        double k = Math.sqrt(2.0 / (1.0 + cosLat * Math.cos(cwLambdaRad)));
        double x = 4.0 * k * cosLat * Math.sin(cwLambdaRad);
        double y = k * sinLat;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

