/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class Eckert5
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Eckert V";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERM1 = Math.sqrt(5.141592653589793);
    private static final double ONE_OVER_TERM1 = 1.0 / TERM1;
    private static final double TWO_OVER_TERM1 = 2.0 * ONE_OVER_TERM1;
    private static final double WIDTH_FACTOR = 2.0 * ONE_OVER_TERM1 * Math.PI;
    private static final double HEIGHT_FACTOR = ONE_OVER_TERM1 * Math.PI;
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public Eckert5(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Eckert5(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Eckert5(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        this.clearInverseArray();
        double oneOver2RS = 0.5 / this.rS;
        for (int iy = 0; iy < this.dstMax.y && !((phiRad = (y = (double)iy + 0.5) * oneOver2RS * TERM1) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Eckert5.toDegrees(phiRad);
            double xFactor = this.oneOverRS * TERM1 / (1.0 + Math.cos(phiRad));
            for (int ix = 0; ix < this.dstMax.x && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Eckert5.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Eckert5.toRadians(lat);
        double x = this.transformLon2LambdaRad(lon) * (1.0 + Math.cos(phiRad)) * ONE_OVER_TERM1;
        double y = phiRad * TWO_OVER_TERM1;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

