/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class Eckert4
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Eckert IV";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TWO_PLUS_HALF_PI = 3.5707963267948966;
    private static final double TERM1 = Math.sqrt(1.7596033859537705);
    private static final double TERM2 = TERM1 / Math.PI;
    private static final double ONE_OVER_TERM2 = 1.0 / TERM2;
    private static final double TERM3 = 0.5 * TERM1 * TERM1 / Math.PI;
    private static final double WIDTH_FACTOR = 2.0 * TERM1;
    private static final double HEIGHT_FACTOR = TERM1;
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public Eckert4(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Eckert4(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Eckert4(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double cosTheta;
        double sinTheta;
        double y;
        double thetaRad;
        double phiRad;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phiRad = Math.asin(((thetaRad = Math.asin((y = (double)iy + 0.5) * this.oneOverRS / TERM1)) + (sinTheta = Math.sin(thetaRad)) * (2.0 + (cosTheta = Math.cos(thetaRad)))) * TERM3)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Eckert4.toDegrees(phiRad);
            double xFactor = this.oneOverRS * ONE_OVER_TERM2 / (1.0 + cosTheta);
            for (int ix = 0; ix < this.dstMax.x && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Eckert4.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiFactor = 3.5707963267948966 * Math.sin(Eckert4.toRadians(lat));
        double thetaRad = Eckert4.toRadians(0.5 * lat);
        for (int i = 0; i < 25; ++i) {
            double sinTheta = Math.sin(thetaRad);
            double cosTheta = Math.cos(thetaRad);
            double dthetaRad = (phiFactor - sinTheta * (2.0 + cosTheta) - thetaRad) / (2.0 * cosTheta * (1.0 + cosTheta));
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double x = TERM2 * this.transformLon2LambdaRad(lon) * (1.0 + Math.cos(thetaRad));
        double y = TERM1 * Math.sin(thetaRad);
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

