/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class Eckert3
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Eckert III";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double CSUBX = 2.0 / Math.sqrt(22.43597501544853);
    private static final double ONE_OVER_CSUBX = 1.0 / CSUBX;
    private static final double WIDTH_FACTOR = CSUBX * (Math.PI * 2);
    private static final double HEIGHT_FACTOR = CSUBX * Math.PI;
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public Eckert3(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Eckert3(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Eckert3(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        this.clearInverseArray();
        double oneOver2RS = 0.5 * this.oneOverRS;
        for (int iy = 0; iy < this.dstMax.y && !((phiRad = (y = (double)iy + 0.5) * oneOver2RS * ONE_OVER_CSUBX) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Eckert3.toDegrees(phiRad);
            double twoPhiOverPi = phiRad * 0.6366197723675814;
            double xFactor = ONE_OVER_CSUBX * this.oneOverRS / (1.0 + Math.sqrt(1.0 - twoPhiOverPi * twoPhiOverPi));
            for (int ix = 0; ix < this.dstMax.x && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Eckert3.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Eckert3.toRadians(lat);
        double twoPhiOverPi = phiRad * 0.6366197723675814;
        double x = CSUBX * this.transformLon2LambdaRad(lon) * (1.0 + Math.sqrt(1.0 - twoPhiOverPi * twoPhiOverPi));
        double y = CSUBX * 2.0 * phiRad;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

