/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class Denoyer
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Denoyer Semi-Elliptical";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double ASPECT_RATIO = 2.0;

    public Denoyer(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Denoyer(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Denoyer(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, Math.PI, 1.5707963267948966, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 2.0;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        this.clearInverseArray();
        block0: for (int iy = 0; iy < this.dstMax.y && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRS) > 1.5707963267948966); ++iy) {
            double phi = Denoyer.toDegrees(phiRad);
            double phiTerm = phiRad * (0.9 + 0.03 * phiRad * phiRad * phiRad * phiRad);
            double lambdaRad = 0.5;
            for (int ix = 0; ix < this.dstMax.x; ++ix) {
                double x = (double)ix + 0.5;
                double xOverRS = x * this.oneOverRS;
                for (int i = 0; i < 25; ++i) {
                    double lambdaRad2 = lambdaRad * lambdaRad;
                    double z = (0.95 + lambdaRad * (-0.08333333333333333 + lambdaRad2 / 600.0)) * phiTerm;
                    double dz = (-0.08333333333333333 + lambdaRad2 / 200.0) * phiTerm;
                    double cosTerm = Math.cos(z);
                    double dcosTerm = -Math.sin(z) * dz;
                    double top = -(lambdaRad * cosTerm - xOverRS);
                    double bottom = cosTerm + lambdaRad * dcosTerm;
                    double dLambdaRad = top / bottom;
                    lambdaRad += dLambdaRad;
                    if (Math.abs(dLambdaRad) < 1.0E-5) break;
                }
                if (lambdaRad > Math.PI) continue block0;
                this.setQSymmetricPoints(ix, iy, Denoyer.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Denoyer.toRadians(lat);
        double phiTerm = phiRad * (0.9 + 0.03 * phiRad * phiRad * phiRad * phiRad);
        double lambdaRad = this.transformLon2LambdaRad(lon);
        double absLRad = Math.abs(lambdaRad);
        double lambdaRad2 = absLRad * absLRad;
        double z = (0.95 + absLRad * (-0.08333333333333333 + lambdaRad2 / 600.0)) * phiTerm;
        double x = lambdaRad * Math.cos(z);
        double y = phiRad;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

