/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.mapping.proj.QuadSymmetricProjection;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public abstract class CurvePoleProjection
extends QuadSymmetricProjection {
    public void drawBorder(Graphics2D g2d) {
        if (this.borderStroke == null || this.foreground == null) {
            return;
        }
        g2d.setStroke(this.borderStroke);
        g2d.setColor(this.foreground);
        this.makeBezier().paint(g2d);
    }

    private Bezier makeBezier() {
        double edgeLon = this.cop.x + 180.0 - 0.05;
        int np = 30;
        double npfact = 3.0;
        Point2D.Double[] dots = new Point2D.Double[121];
        for (int j = 0; j <= 30; ++j) {
            double jj = 3.0 * (double)j;
            Point2D.Double dot = this.transformLL2XY(edgeLon, jj);
            if (dot.x < (double)this.dstCenter.x) {
                dot.x += 2.0 * ((double)this.dstCenter.x - dot.x);
            }
            dots[j] = new Point2D.Double(dot.x, dot.y);
            dots[60 - j] = new Point2D.Double(2.0 * (double)this.dstCenter.x - dot.x, dot.y);
            dots[60 + j] = new Point2D.Double(2.0 * (double)this.dstCenter.x - dot.x, 2.0 * (double)this.dstCenter.y - dot.y);
            dots[120 - j] = new Point2D.Double(dot.x, 2.0 * (double)this.dstCenter.y - dot.y);
        }
        return new Bezier(true, dots);
    }
}

