/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.mapping.proj.PointPoleProjection;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public abstract class ConcavePoleProjection
extends PointPoleProjection {
    private Bezier[] curves = new Bezier[2];

    public void drawBorder(Graphics2D g2d) {
        if (this.borderStroke == null || this.foreground == null) {
            return;
        }
        super.drawBorder(g2d);
        this.makePoleBezier();
        g2d.setStroke(this.borderStroke);
        g2d.setColor(this.foreground);
        this.curves[0].paint(g2d);
        this.curves[1].paint(g2d);
    }

    protected void makePoleBezier() {
        int np = 45;
        double npfact = 4.0;
        Point2D.Double[] dotsN = new Point2D.Double[91];
        Point2D.Double[] dotsS = new Point2D.Double[91];
        for (int i = 0; i <= 45; ++i) {
            double ii = 4.0 * (double)i;
            if (i == 45) {
                ii -= 0.1;
            }
            Point2D.Double dot = this.transformLL2XY(this.cop.x + ii, 90.0);
            dotsN[45 - i] = new Point2D.Double(dot.x, dot.y);
            dotsN[45 + i] = new Point2D.Double(2.0 * (double)this.dstCenter.x - dot.x, dot.y);
            dotsS[45 - i] = new Point2D.Double(dot.x, 2.0 * (double)this.dstCenter.y - dot.y);
            dotsS[45 + i] = new Point2D.Double(2.0 * (double)this.dstCenter.x - dot.x, 2.0 * (double)this.dstCenter.y - dot.y);
        }
        this.curves[0] = new Bezier(false, dotsN);
        this.curves[1] = new Bezier(false, dotsS);
    }
}

