/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.CurvePoleProjection;
import java.awt.geom.Point2D;

public class CantersPseudocylindricalPP
extends CurvePoleProjection {
    private static final String PROJECTION_NAME = "Canters Pseudocylindrical PP";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double C0 = 0.8333;
    private static final double C2 = -0.3385;
    private static final double C4 = 0.0942;
    private static final double C1P = 1.0114;
    private static final double C3P = 0.0243;
    private static final double C5P = -0.0391;
    private static final double THREE_C3P = 0.07289999999999999;
    private static final double FIVE_C5P = -0.1955;
    private static final double WIDTH_FACTOR = 2.6178891582363746;
    private static final double HEIGHT_FACTOR = 1.3089671679897534;
    private static final double ASPECT_RATIO = 1.9999654859615756;

    public CantersPseudocylindricalPP(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public CantersPseudocylindricalPP(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public CantersPseudocylindricalPP(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, 2.6178891582363746, 1.3089671679897534, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 1.9999654859615756;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        double phiRad = 0.0;
        block0: for (int iy = 0; iy < this.dstMax.y; ++iy) {
            double phiRad2;
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS;
            phiRad += 1.0E-5;
            for (int iter = 0; iter < 25; ++iter) {
                phiRad2 = phiRad * phiRad;
                double dphiRad = -(phiRad * (1.0114 + phiRad2 * (0.0243 + phiRad2 * -0.0391)) - yOverRS) / (1.0114 + phiRad2 * (0.07289999999999999 + phiRad2 * -0.1955));
                phiRad += dphiRad;
                if (Math.abs(dphiRad) < 1.0E-5) break;
            }
            if (phiRad > 1.5707963267948966) break;
            double phi = CantersPseudocylindricalPP.toDegrees(phiRad);
            phiRad2 = phiRad * phiRad;
            double xFactor = this.oneOverRS / ((0.8333 + phiRad2 * (-0.3385 + phiRad2 * 0.0942)) * Math.cos(phiRad));
            for (int ix = 0; ix < this.dstMax.x; ++ix) {
                double x = (double)ix + 0.5;
                double lambdaRad = phiRad >= 1.5707963267948966 ? 0.0 : x * xFactor;
                if (lambdaRad > Math.PI) continue block0;
                this.setQSymmetricPoints(ix, iy, CantersPseudocylindricalPP.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = CantersPseudocylindricalPP.toRadians(lat);
        double phiRad2 = phiRad * phiRad;
        double x = this.transformLon2LambdaRad(lon) * Math.cos(phiRad) * (0.8333 + phiRad2 * (-0.3385 + phiRad2 * 0.0942));
        double y = phiRad * (1.0114 + phiRad2 * (0.0243 + phiRad2 * -0.0391));
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

