/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class CantersPseudocylindricalGO
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Canters Pseudocylindrical GO";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double C0 = 0.792;
    private static final double C2 = -0.0978;
    private static final double C4 = 0.0059;
    private static final double C1P = 1.0304;
    private static final double C3P = 0.0127;
    private static final double C5P = -0.025;
    private static final double THREE_C3P = 0.038099999999999995;
    private static final double FIVE_C5P = -0.125;
    private static final double WIDTH_FACTOR = 2.4881413816431164;
    private static final double HEIGHT_FACTOR = 1.4286931206209363;
    private static final double ASPECT_RATIO = 1.7415506141456916;

    public CantersPseudocylindricalGO(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public CantersPseudocylindricalGO(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public CantersPseudocylindricalGO(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, 2.4881413816431164, 1.4286931206209363, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 1.7415506141456916;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        double phiRad = 0.0;
        block0: for (int iy = 0; iy < this.dstMax.y; ++iy) {
            double phiRad2;
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS;
            phiRad += 1.0E-5;
            for (int iter = 0; iter < 25; ++iter) {
                phiRad2 = phiRad * phiRad;
                double dphiRad = -(phiRad * (1.0304 + phiRad2 * (0.0127 + phiRad2 * -0.025)) - yOverRS) / (1.0304 + phiRad2 * (0.038099999999999995 + phiRad2 * -0.125));
                phiRad += dphiRad;
                if (Math.abs(dphiRad) < 1.0E-5) break;
            }
            if (phiRad > 1.5707963267948966) break;
            double phi = CantersPseudocylindricalGO.toDegrees(phiRad);
            phiRad2 = phiRad * phiRad;
            double xFactor = this.oneOverRS / (0.792 + phiRad2 * (-0.0978 + phiRad2 * 0.0059));
            for (int ix = 0; ix < this.dstMax.x; ++ix) {
                double x = (double)ix + 0.5;
                double lambdaRad = phiRad >= 1.5707963267948966 ? 0.0 : x * xFactor;
                if (lambdaRad > Math.PI) continue block0;
                this.setQSymmetricPoints(ix, iy, CantersPseudocylindricalGO.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = CantersPseudocylindricalGO.toRadians(lat);
        double phiRad2 = phiRad * phiRad;
        double x = this.transformLon2LambdaRad(lon) * (0.792 + phiRad2 * (-0.0978 + phiRad2 * 0.0059));
        double y = phiRad * (1.0304 + phiRad2 * (0.0127 + phiRad2 * -0.025));
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

