/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.ConcavePoleProjection;
import java.awt.geom.Point2D;

public class CantersMEPolyconic
extends ConcavePoleProjection {
    private static final String PROJECTION_NAME = "Canters Minimum-Error Polyconic";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double CX1 = 0.9305;
    private static final double CX2 = -0.1968;
    private static final double CX3 = -0.0067;
    private static final double CX4 = 0.0076;
    private static final double CY1 = 0.9305;
    private static final double CY2 = 0.0394;
    private static final double CY3 = 5.0E-4;
    private static final double CY4 = -0.0115;
    private static final double WIDTH_FACTOR = 2.9232519641653023;
    private static final double HEIGHT_FACTOR = 1.709051257002036;
    private static final double ASPECT_RATIO = 1.7104530669800853;

    public CantersMEPolyconic(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public CantersMEPolyconic(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public CantersMEPolyconic(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, 2.9232519641653023, 1.709051257002036, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 1.7104530669800853;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        block0: for (int iy = 0; iy < this.dstMax.y; ++iy) {
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS;
            double phiRad = Math.min(yOverRS / 0.9305, 1.5707863267948965);
            double lambdaRad = 0.0;
            for (int ix = 0; ix < this.dstMax.x; ++ix) {
                double x = (double)ix + 0.5;
                double xOverRS = x * this.oneOverRS;
                int iters = 0;
                for (int iter = 0; iter < 25; ++iter) {
                    double phiRad2 = phiRad * phiRad;
                    double lambdaRad2 = lambdaRad * lambdaRad;
                    double df1dPhi = lambdaRad * phiRad * (-0.3936 + -0.0134 * lambdaRad2 + 0.0304 * phiRad2);
                    double df1dLambda = 0.9305 + phiRad2 * (-0.1968 + -0.0201 * lambdaRad2 + 0.0076 * phiRad2);
                    double df2dPhi = 0.9305 + lambdaRad2 * (0.0394 + 5.0E-4 * lambdaRad2 + -0.0345 * phiRad2);
                    double df2dLambda = phiRad * lambdaRad * (0.0788 + 0.002 * lambdaRad + -0.023 * phiRad2);
                    double f1 = lambdaRad * (0.9305 + phiRad2 * (-0.1968 + -0.0067 * lambdaRad2 + 0.0076 * phiRad2)) - xOverRS;
                    double f2 = phiRad * (0.9305 + lambdaRad2 * (0.0394 + 5.0E-4 * lambdaRad2 + -0.0115 * phiRad2)) - yOverRS;
                    double denom = df1dPhi * df2dLambda - df2dPhi * df1dLambda;
                    double dphiX = (f1 * df2dLambda - f2 * df1dLambda) / denom;
                    double lambdaX = (f2 * df1dPhi - f1 * df2dPhi) / denom;
                    phiRad -= dphiX;
                    lambdaRad -= lambdaX;
                    if (Math.abs(dphiX) < 1.0E-5 && Math.abs(lambdaX) < 1.0E-5) break;
                    ++iters;
                }
                if (iters > 24 || lambdaRad > Math.PI) continue block0;
                double lambda = CantersMEPolyconic.toDegrees(lambdaRad);
                double phi = CantersMEPolyconic.toDegrees(phiRad);
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.transformLon2LambdaRad(lon);
        double lambdaRad2 = lambdaRad * lambdaRad;
        double phiRad = CantersMEPolyconic.toRadians(lat);
        double phiRad2 = phiRad * phiRad;
        double x = lambdaRad * (0.9305 + phiRad2 * (-0.1968 + -0.0067 * lambdaRad2 + 0.0076 * phiRad2));
        double y = phiRad * (0.9305 + lambdaRad2 * (0.0394 + 5.0E-4 * lambdaRad2 + -0.0115 * phiRad2));
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

