/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AzimuthalProjection;
import gov.nasa.giss.mapping.proj.ProjectionBooleanParameter;
import gov.nasa.giss.mapping.proj.ProjectionExtraParameter;
import java.awt.geom.Point2D;

public class AzimEquidistant
extends AzimuthalProjection {
    private static final String PROJECTION_NAME = "Azimuthal Equidistant";
    private static final boolean IS_AZIMUTHAL = true;
    private static final double WIDTH_FACTOR = 1.5707963267948966;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double ASPECT_RATIO = 1.0;
    private boolean fullGlobal = false;
    private double rhoMax = 1.0;
    private double rhoMax2 = 1.0;

    public AzimEquidistant(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public AzimEquidistant(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public AzimEquidistant(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, true, 1.5707963267948966, 1.5707963267948966, dw, dh, xm, ym);
        this.setExtraParameters(new ProjectionExtraParameter[]{new ProjectionBooleanParameter("Show Full Globe", false)});
        this.extraParameterChanged();
    }

    public void extraParameterChanged() {
        ProjectionBooleanParameter p = (ProjectionBooleanParameter)this.getParameter(1);
        this.fullGlobal = p.isSelected();
        this.fitToTarget();
        this.needsUpdate = true;
    }

    protected void fitToTarget() {
        this.widthFactor = this.fullGlobal ? Math.PI : 1.5707963267948966;
        this.heightFactor = this.fullGlobal ? Math.PI : 1.5707963267948966;
        super.fitToTarget();
        this.rhoMax = this.rS * this.heightFactor;
        this.rhoMax2 = this.rhoMax * this.rhoMax;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return true;
    }

    public static double getAspectRatio() {
        return 1.0;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        for (int iy = -this.dstMax.y; iy < this.dstMax.y; ++iy) {
            double y = (double)iy + 0.5;
            double y2 = y * y;
            for (int ix = 0; ix < this.dstMax.x; ++ix) {
                double x = (double)ix + 0.5;
                double rho2 = x * x + y2;
                if (rho2 > this.rhoMax2) continue;
                double rho = Math.sqrt(rho2);
                double c = rho * this.oneOverRS;
                double sinC = Math.sin(c);
                double cosC = Math.cos(c);
                double phiRad = Math.asin(cosC * this.sinLatCOP + y * sinC * this.cosLatCOP / rho);
                double lambdaRad = Math.atan2(x * sinC, rho * this.cosLatCOP * cosC - y * this.sinLatCOP * sinC);
                this.setBiSymmetricPoints(ix, iy, AzimEquidistant.toDegrees(lambdaRad), AzimEquidistant.toDegrees(phiRad));
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        double k;
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = AzimEquidistant.toRadians(lon - this.cop.x);
        double cosLambda = Math.cos(lambdaRad);
        double cosLat = Math.cos(AzimEquidistant.toRadians(lat));
        double sinLat = Math.sin(AzimEquidistant.toRadians(lat));
        double c = Math.acos(this.sinLatCOP * sinLat + this.cosLatCOP * cosLat * Math.cos(lambdaRad));
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(c) > 1.0E-5 && ((x = (k = c / Math.sin(c)) * cosLat * Math.sin(lambdaRad)) * x + (y = k * (this.cosLatCOP * sinLat - this.sinLatCOP * cosLat * cosLambda)) * y) * (this.rS * this.rS) > this.rhoMax2) {
            return null;
        }
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

