/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AzimuthalProjection;
import gov.nasa.giss.mapping.proj.ProjectionBooleanParameter;
import gov.nasa.giss.mapping.proj.ProjectionExtraParameter;
import java.awt.geom.Point2D;

public class AzimEqualarea
extends AzimuthalProjection {
    private static final String PROJECTION_NAME = "Azimuthal Equal-Area";
    private static final boolean IS_AZIMUTHAL = true;
    private static final double WIDTH_FACTOR;
    private static final double HEIGHT_FACTOR;
    private static final double ASPECT_RATIO;
    private boolean fullGlobal = false;
    private double rhoMax = 1.0;
    private double rhoMax2 = 1.0;

    public AzimEqualarea(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public AzimEqualarea(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public AzimEqualarea(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, true, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
        this.setExtraParameters(new ProjectionExtraParameter[]{new ProjectionBooleanParameter("Show Full Globe", false)});
        this.extraParameterChanged();
    }

    public void extraParameterChanged() {
        ProjectionBooleanParameter p = (ProjectionBooleanParameter)this.getParameter(1);
        this.fullGlobal = p.isSelected();
        this.fitToTarget();
        this.needsUpdate = true;
    }

    protected void fitToTarget() {
        this.widthFactor = this.fullGlobal ? SQRT2 * WIDTH_FACTOR : WIDTH_FACTOR;
        this.heightFactor = this.fullGlobal ? SQRT2 * HEIGHT_FACTOR : HEIGHT_FACTOR;
        super.fitToTarget();
        this.rhoMax = this.rS * this.heightFactor;
        this.rhoMax2 = this.rhoMax * this.rhoMax;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return true;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        double oneOver2RS = 0.5 * this.oneOverRS;
        for (int iy = -this.dstMax.y; iy < this.dstMax.y; ++iy) {
            double y = (double)iy + 0.5;
            double y2 = y * y;
            for (int ix = 0; ix < this.dstMax.x; ++ix) {
                double x = (double)ix + 0.5;
                double rho2 = x * x + y2;
                if (rho2 > this.rhoMax2) continue;
                double rho = Math.sqrt(rho2);
                double c = 2.0 * Math.asin(rho * oneOver2RS);
                double sinC = Math.sin(c);
                double cosC = Math.cos(c);
                double phiRad = Math.asin(cosC * this.sinLatCOP + y * sinC * this.cosLatCOP / rho);
                double lambdaRad = Math.atan2(x * sinC, rho * this.cosLatCOP * cosC - y * this.sinLatCOP * sinC);
                this.setBiSymmetricPoints(ix, iy, AzimEqualarea.toDegrees(lambdaRad), AzimEqualarea.toDegrees(phiRad));
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        double y;
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = AzimEqualarea.toRadians(lon - this.cop.x);
        double cosLambda = Math.cos(lambdaRad);
        double cosLat = Math.cos(AzimEqualarea.toRadians(lat));
        double sinLat = Math.sin(AzimEqualarea.toRadians(lat));
        double k = Math.sqrt(2.0 / (1.0 + this.sinLatCOP * sinLat + this.cosLatCOP * cosLat * cosLambda));
        double x = k * cosLat * Math.sin(lambdaRad);
        if ((x * x + (y = k * (this.cosLatCOP * sinLat - this.sinLatCOP * cosLat * cosLambda)) * y) * (this.rS * this.rS) > this.rhoMax2) {
            return null;
        }
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }

    static {
        HEIGHT_FACTOR = WIDTH_FACTOR = SQRT2;
        ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;
    }
}

