/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.EllipseProjection;
import java.awt.geom.Point2D;

public class ApianGlobular2
extends EllipseProjection {
    private static final String PROJECTION_NAME = "Apian Globular II";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double HALF_PI_SQUARE = 2.4674011002723395;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double ASPECT_RATIO = 2.0;

    public ApianGlobular2(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public ApianGlobular2(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public ApianGlobular2(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, Math.PI, 1.5707963267948966, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 2.0;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRS) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = ApianGlobular2.toDegrees(phiRad);
            double xFactor = 1.5707963267948966 * this.oneOverRS / Math.sqrt(2.4674011002723395 - phiRad * phiRad);
            for (int ix = 0; ix < this.dstMax.x && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, ApianGlobular2.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = ApianGlobular2.toRadians(lat);
        double x = 0.6366197723675814 * this.transformLon2LambdaRad(lon) * Math.sqrt(2.4674011002723395 - phiRad * phiRad);
        double y = phiRad;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

