/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.EllipseProjection;
import java.awt.geom.Point2D;

public class ApianGlobular1
extends EllipseProjection {
    private static final String PROJECTION_NAME = "Apian Globular I";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double QUARTER_PI2 = 2.4674011002723395;
    private static final double WIDTH_FACTOR = 1.5707963267948966;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double ASPECT_RATIO = 1.0;

    public ApianGlobular1(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public ApianGlobular1(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public ApianGlobular1(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, 1.5707963267948966, 1.5707963267948966, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 1.0;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        double rhoMax = this.rS * this.heightFactor;
        double rhoMax2 = rhoMax * rhoMax;
        double r2s2 = this.rS * this.rS;
        for (int iy = 0; iy < this.dstMax.y; ++iy) {
            double y = (double)iy + 0.5;
            double y2 = y * y;
            double phiRad = y * this.oneOverRS;
            if (phiRad > 1.5707963267948966) continue;
            double phi = ApianGlobular1.toDegrees(phiRad);
            double phiRad2 = phiRad * phiRad;
            for (int ix = 0; ix < this.dstMax.x; ++ix) {
                double lambdaRad;
                double x = (double)ix + 0.5;
                double rho2 = x * x + y2;
                if (rho2 > rhoMax2) continue;
                if (x == 0.0) {
                    lambdaRad = 0.0;
                } else if (y == 0.0) {
                    lambdaRad = x * this.oneOverRS;
                } else {
                    double b = -(rho2 - r2s2 * 2.4674011002723395) / (x * this.rS);
                    double c = -2.4674011002723395;
                    lambdaRad = 0.5 * (-b + Math.sqrt(b * b - 4.0 * c));
                }
                this.setQSymmetricPoints(ix, iy, ApianGlobular1.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.transformLon2LambdaRad(lon);
        double y = ApianGlobular1.toRadians(lat);
        double x = 0.0;
        if (this.cop.x != lon) {
            double phiRad = ApianGlobular1.toRadians(lat);
            double absLambdaRad = Math.abs(lambdaRad);
            double f = 0.5 * (absLambdaRad + 2.4674011002723395 / absLambdaRad);
            x = absLambdaRad - f + Math.sqrt(f * f - phiRad * phiRad);
            if (lambdaRad < 0.0) {
                x *= -1.0;
            }
        }
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

