/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.EllipseProjection;
import java.awt.geom.Point2D;

public class Aitoff
extends EllipseProjection {
    private static final String PROJECTION_NAME = "Aitoff";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double ASPECT_RATIO = 2.0;

    public Aitoff(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Aitoff(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Aitoff(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, Math.PI, 1.5707963267948966, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 2.0;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        block0: for (int iy = 0; iy < this.dstMax.y; ++iy) {
            double y = (double)iy + 0.5;
            double y2 = y * y;
            double yOverRS = y * this.oneOverRS;
            for (int ix = 0; ix < this.dstMax.x; ++ix) {
                double lambdaRad;
                double phiRad;
                double x = (double)ix + 0.5;
                double d = Math.sqrt(0.25 * x * x + y2) * this.oneOverRS;
                if (d > 1.0E-5) {
                    phiRad = Math.asin(yOverRS * Math.sin(d) / d);
                    if (phiRad < 1.5707963267948966) {
                        lambdaRad = 2.0 * Math.acos(Math.cos(d) / Math.cos(phiRad));
                    } else {
                        if (phiRad > 1.5707963267948966) continue block0;
                        lambdaRad = 0.0;
                    }
                    if (lambdaRad > Math.PI) {
                        continue block0;
                    }
                } else {
                    phiRad = 0.0;
                    lambdaRad = 0.0;
                }
                this.setQSymmetricPoints(ix, iy, Aitoff.toDegrees(lambdaRad), Aitoff.toDegrees(phiRad));
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        if (lat == 0.0) {
            double x = this.transformLon2LambdaRad(lon);
            return new Point2D.Double((double)this.dstCenter.x + x * this.rS, this.dstCenter.y);
        }
        double lambdaRad = this.transformLon2LambdaRad(lon);
        double phiRad = Aitoff.toRadians(lat);
        if (lambdaRad == 0.0) {
            double y = phiRad;
            return new Point2D.Double(this.dstCenter.x, (double)this.dstCenter.y - y * this.rS);
        }
        double d = Math.acos(Math.cos(phiRad) * Math.cos(0.5 * lambdaRad));
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(d) > 1.0E-5) {
            double cosA = Math.sin(phiRad) / Math.sin(d);
            x = 2.0 * d * Math.sqrt(1.0 - cosA * cosA);
            y = d * cosA;
            if (lambdaRad < 0.0) {
                x = -x;
            }
        }
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

