/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.geom.DimensionD;
import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.mapping.MappingConstants;
import gov.nasa.giss.mapping.proj.ProjectionDescription;
import gov.nasa.giss.mapping.proj.ProjectionExtraParameter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Vector;

public abstract class AbstractProjection
implements MappingConstants {
    private static final int UNDEFINED = -100;
    private static final double UNKNOWN = 9999.0;
    private static final double DEFAULT_COP_LON = 0.0;
    private static final double DEFAULT_COP_LAT = 0.0;
    private static final Color DEFAULT_BACKGROUND = Color.white;
    private static final Color DEFAULT_GRID_COLOR = Color.gray;
    private static final BasicStroke DEFAULT_GRID_STROKE = new BasicStroke(1.0f);
    private static final Color DEFAULT_FOREGROUND = new Color(DEFAULT_BACKGROUND.getRGB() ^ 0xFFFFFF);
    private static final BasicStroke DEFAULT_BORDER_STROKE = new BasicStroke(1.75f);
    private static final int GRID_FHGT = 10;
    private static final Font GRID_FONT = new Font("Monospaced", 0, 10);
    protected static final double REALLY_SMALL = 1.0E-5;
    protected static final int ITER_MAX = 25;
    protected BufferedImage source;
    protected Dimension srcSize = new Dimension(1, 1);
    protected DimensionD srcPixSize = new DimensionD(0.0, 0.0);
    private Point srcCenter = new Point(0, 0);
    protected Dimension dstSize = new Dimension(1, 1);
    protected Point dstCenter = new Point(0, 0);
    protected Dimension useSize = new Dimension(0, 0);
    protected Dimension marginSize = new Dimension(0, 0);
    protected int[] invArray;
    protected double[] invArrayLon;
    protected double[] invArrayLat;
    protected Color background;
    protected int backgroundInt;
    protected Point2D.Double cop = new Point2D.Double(0.0, 0.0);
    protected double cosLatCOP;
    protected double sinLatCOP;
    protected Color foreground = DEFAULT_FOREGROUND;
    protected BasicStroke borderStroke = DEFAULT_BORDER_STROKE;
    protected Color gridColor = DEFAULT_GRID_COLOR;
    protected BasicStroke gridStroke = DEFAULT_GRID_STROKE;
    protected int gridSpacing = 30;
    protected boolean gridLabeled = false;
    protected Color pathColor = Color.red;
    protected BasicStroke pathStroke = new BasicStroke(1.0f, 1, 1);
    protected Point2D.Double[] pathPoints;
    protected static final double BAD_POINT = 9999.0;
    private boolean azimuthal;
    protected double scaleFactor = 1.0;
    protected double widthFactor = 1.0;
    protected double heightFactor = 1.0;
    protected double rS = 1.0;
    protected double oneOverRS = 1.0;
    protected Point dstMax = new Point(1, 1);
    protected boolean needsUpdate = true;
    private String pname;
    protected ProjectionExtraParameter[] extraParams = new ProjectionExtraParameter[0];

    protected void init(String s, boolean b, double wf, double hf, int dw, int dh, int xm, int ym) {
        this.pname = s;
        this.azimuthal = b;
        this.widthFactor = wf;
        this.heightFactor = hf;
        this.setCenter(0.0, 0.0);
        this.setBackground(DEFAULT_BACKGROUND);
        this.setForeground(DEFAULT_FOREGROUND);
        this.setSize(dw, dh, xm, ym);
    }

    public double getAspectRatio2() {
        return this.widthFactor / this.heightFactor;
    }

    public boolean isAzimuthal2() {
        return this.azimuthal;
    }

    public Dimension getSize() {
        return this.dstSize;
    }

    public void setSize(int dw, int dh, int xm, int ym) {
        this.dstSize.width = dw;
        this.dstSize.height = dh;
        this.marginSize.width = xm;
        this.marginSize.height = ym;
        this.dstCenter.x = (short)(0.5 * (double)this.dstSize.width);
        this.dstCenter.y = (short)(0.5 * (double)this.dstSize.height);
        this.useSize.width = this.dstSize.width - 2 * this.marginSize.width;
        this.useSize.height = this.dstSize.height - 2 * this.marginSize.height;
        this.invArray = null;
        this.fitToTarget();
        this.needsUpdate = true;
    }

    protected void fitToTarget() {
        double radius = 0.5 * Math.min((double)this.useSize.height / this.heightFactor, (double)this.useSize.width / this.widthFactor);
        this.rS = radius * this.scaleFactor;
        this.oneOverRS = 1.0 / this.rS;
        this.dstMax.x = (int)(Math.min(0.5 * (double)this.useSize.width, this.rS * this.widthFactor) + 0.5);
        this.dstMax.y = (int)(Math.min(0.5 * (double)this.useSize.height, this.rS * this.heightFactor) + 0.5);
    }

    public String getName() {
        return this.pname;
    }

    public ProjectionDescription getDescription() {
        ProjectionDescription pd = new ProjectionDescription(this.getName());
        pd.setCenter(this.cop.x, this.cop.y);
        pd.setScaling(this.scaleFactor);
        pd.setBackground(this.background);
        pd.setForeground(this.foreground);
        pd.setGridColor(this.gridColor);
        pd.setGridStroke(this.gridStroke);
        pd.setGridLabeled(this.gridLabeled);
        pd.setPathPoints(this.pathPoints);
        pd.setPathColor(this.pathColor);
        pd.setPathStroke(this.pathStroke);
        pd.setBorderStroke(this.borderStroke);
        return pd;
    }

    public void setDescription(ProjectionDescription pd) {
        this.setCenter(pd.getCenterLon(), pd.getCenterLat());
        this.setScaling(pd.getScaling());
        this.setBackground(pd.getBackground());
        this.setForeground(pd.getForeground());
        this.setGridColor(pd.getGridColor());
        this.setGridStroke(pd.getGridStroke());
        this.setGridLabeled(pd.getGridLabeled());
        this.setPathPoints(pd.getPathPoints());
        this.setPathColor(pd.getPathColor());
        this.setPathColor(pd.getPathColor());
        this.setBorderStroke(pd.getBorderStroke());
    }

    public Point getCenterXY() {
        return (Point)this.dstCenter.clone();
    }

    public void setCenter(double lon) {
        this.setCenter(lon, 0.0);
    }

    public void setCenter(double lon, double lat) {
        this.cop.x = lon;
        this.cop.y = lat;
        this.cosLatCOP = Math.cos(AbstractProjection.toRadians(this.cop.y));
        this.sinLatCOP = Math.sin(AbstractProjection.toRadians(this.cop.y));
        this.needsUpdate = true;
    }

    public double getScaling() {
        return this.scaleFactor;
    }

    public void setScaling(double d) {
        if (d == this.scaleFactor) {
            return;
        }
        this.scaleFactor = d;
        this.fitToTarget();
        this.needsUpdate = true;
    }

    public void zoom(double d) {
        if (d == 1.0) {
            return;
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("Illegal zoom factor");
        }
        this.setScaling(this.getScaling() * d);
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color c) {
        this.background = c;
        this.backgroundInt = this.background.getRGB();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color c) {
        this.foreground = c;
    }

    public BasicStroke getBorderStroke() {
        return this.borderStroke;
    }

    public void setBorderStroke(BasicStroke stroke) {
        this.borderStroke = stroke;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public BasicStroke getGridStroke() {
        return this.gridStroke;
    }

    public void setGridStroke(BasicStroke stroke) {
        this.gridStroke = stroke;
    }

    public int getGridSpacing() {
        return this.gridSpacing;
    }

    public void setGridSpacing(int value) {
        this.gridSpacing = value;
        this.gridSpacing = Math.max(this.gridSpacing, 5);
        this.gridSpacing = Math.min(this.gridSpacing, 180);
    }

    public boolean isGridLabeled() {
        return this.gridLabeled;
    }

    public void setGridLabeled(boolean b) {
        this.gridLabeled = b;
    }

    public void setPathPoints(Point2D.Double[] dots) {
        this.pathPoints = dots;
    }

    public void setPathColor(Color color) {
        this.pathColor = color;
    }

    public void setPathStroke(BasicStroke stroke) {
        this.pathStroke = stroke;
    }

    public BufferedImage getSourceMap() {
        return this.source;
    }

    public void setSourceMap(BufferedImage i) {
        if (i == null) {
            throw new IllegalArgumentException("Source map image must not be null.");
        }
        this.source = i;
        int xw = this.source.getWidth(null);
        int xh = this.source.getHeight(null);
        if (xw != this.srcSize.width || xh != this.srcSize.height) {
            this.srcSize.width = xw;
            this.srcSize.height = xh;
            this.srcCenter.x = xw / 2;
            this.srcCenter.y = xh / 2;
            this.srcPixSize.width = (double)xw / 360.0;
            this.srcPixSize.height = (double)xh / 180.0;
            this.needsUpdate = true;
        }
    }

    public int getParameterCount() {
        return this.extraParams.length;
    }

    public ProjectionExtraParameter getParameter(int pid) {
        if (pid > this.extraParams.length) {
            throw new IllegalArgumentException("Bad parameter number.");
        }
        return this.extraParams[pid - 1];
    }

    public void extraParameterChanged() {
    }

    protected void setExtraParameters(ProjectionExtraParameter[] array) {
        this.extraParams = array;
        for (int i = 0; i < this.extraParams.length; ++i) {
            this.extraParams[i].setParent(this);
        }
    }

    public void drawCompleteMap(Graphics2D g2d) {
        if (this.needsUpdate) {
            this.calculateInverseArray();
        }
        this.drawMap(g2d);
        this.drawPath(g2d, this.pathPoints, this.pathStroke, this.pathColor);
        this.drawGrid(g2d);
        this.drawBorder(g2d);
    }

    public void drawMap(Graphics2D g2d) {
        if (this.needsUpdate) {
            this.calculateInverseArray();
        }
        g2d.setColor(this.background);
        g2d.fillRect(0, 0, this.dstSize.width, this.dstSize.height);
        this.drawMapUsingInvArray(g2d);
    }

    public void printMap(Graphics2D g2d) {
        this.drawMap(g2d);
    }

    protected void drawMapUsingInvArray(Graphics2D g2d) {
        if (this.source == null) {
            throw new IllegalArgumentException("Source map image has not been provided.");
        }
        int maxSrcPixels = this.srcSize.width * this.srcSize.height;
        int maxDstPixels = this.dstSize.width * this.dstSize.height;
        int[] srcPixels = new int[maxSrcPixels];
        int[] dstPixels = new int[maxDstPixels];
        try {
            PixelGrabber grabber = new PixelGrabber(this.source, 0, 0, this.srcSize.width, this.srcSize.height, srcPixels, 0, this.srcSize.width);
            try {
                grabber.grabPixels();
            }
            catch (Exception exc) {
                return;
            }
            int offset = 0;
            int rowOffset = 0;
            for (int row = 0; row < this.dstSize.height; ++row) {
                rowOffset = row * this.dstSize.width;
                for (int col = 0; col < this.dstSize.width; ++col) {
                    offset = rowOffset + col;
                    dstPixels[offset] = this.invArray[offset] >= 0 && this.invArray[offset] < maxSrcPixels ? srcPixels[this.invArray[offset]] : this.backgroundInt;
                }
            }
            g2d.setColor(this.background);
            g2d.fillRect(0, 0, this.dstSize.width, this.dstSize.height);
            g2d.drawImage(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.dstSize.width, this.dstSize.height, dstPixels, 0, this.dstSize.width)), 0, 0, null);
        }
        catch (Exception exc) {
            System.out.println("ERROR: drawMapUsingInvArray error : " + exc.toString());
        }
    }

    public void drawGrid(Graphics2D g2d) {
        this.drawGrid(g2d, this.gridStroke, this.gridColor);
    }

    public void drawGrid(Graphics2D g2d, BasicStroke stroke, Color color) {
        if (color == null || stroke == null) {
            return;
        }
        Bezier[] curves = this.makeGridCurves();
        g2d.setColor(color);
        g2d.setStroke(stroke);
        for (int i = 0; i < curves.length; ++i) {
            if (curves[i] == null) continue;
            curves[i].paint(g2d);
        }
    }

    public void drawPath(Graphics2D g2d) {
        this.drawPath(g2d, this.pathPoints, this.pathStroke, this.pathColor);
    }

    public void drawPath(Graphics2D g2d, Point2D.Double[] odots) {
        this.drawPath(g2d, odots, this.pathStroke, this.pathColor);
    }

    public void drawPath(Graphics2D g2d, Point2D.Double[] odots, BasicStroke stroke, Color color) {
        if (color == null || color.getAlpha() == 0 || stroke == null || odots == null || odots.length == 0) {
            return;
        }
        g2d.setColor(color);
        g2d.setStroke(stroke);
        Point2D.Double[] tdots = this.translatePoints(odots);
        Point2D.Double lastPt = null;
        GeneralPath path = new GeneralPath();
        for (int i = 0; i < tdots.length; ++i) {
            if (lastPt == null) {
                if (tdots[i] == null) continue;
                path.moveTo((float)tdots[i].x, (float)tdots[i].y);
            } else if (tdots[i] == null) {
                g2d.draw(path);
                path.reset();
            } else {
                path.lineTo((float)tdots[i].x, (float)tdots[i].y);
            }
            lastPt = tdots[i];
        }
        g2d.draw(path);
    }

    public abstract void drawBorder(Graphics2D var1);

    protected int getSrcPixelX(double lon) {
        int x;
        if (this.srcSize.width < 1) {
            return 0;
        }
        for (x = (int)((double)this.srcCenter.x + this.srcPixSize.width * lon - 0.5); x >= this.srcSize.width; x -= this.srcSize.width) {
        }
        while (x < 0) {
            x += this.srcSize.width;
        }
        return x;
    }

    protected int getSrcPixelY(double lat) {
        if (this.srcSize.height < 1) {
            return 0;
        }
        return (int)((double)this.srcCenter.y - this.srcPixSize.height * lat - 0.5);
    }

    public Point2D.Double transformXY2LL(int x, int y) {
        if (this.needsUpdate) {
            this.calculateInverseArray();
        }
        if (x < this.marginSize.width || x > this.dstSize.width - this.marginSize.width || y < this.marginSize.height || y > this.dstSize.height - this.marginSize.height) {
            return null;
        }
        int offset = y * this.dstSize.width + x;
        if (offset < 0 || offset >= this.invArray.length || this.invArray[offset] < 0) {
            return null;
        }
        if (Double.isNaN(this.invArrayLon[offset]) || Double.isNaN(this.invArrayLat[offset])) {
            return null;
        }
        Point2D.Double latlong = new Point2D.Double(this.invArrayLon[offset], this.invArrayLat[offset]);
        return latlong;
    }

    public double transformLon2Lambda(double lon) {
        double lambda;
        for (lambda = lon - this.cop.x; lambda > 180.0; lambda -= 360.0) {
        }
        while (lambda < -180.0) {
            lambda += 360.0;
        }
        return lambda;
    }

    public double transformLon2LambdaRad(double lon) {
        return AbstractProjection.toRadians(this.transformLon2Lambda(lon));
    }

    public abstract Point2D.Double transformLL2XY(double var1, double var3);

    public Point transformLL2XYInt(double lon, double lat) {
        Point2D.Double p2d = this.transformLL2XY(lon, lat);
        if (p2d == null) {
            return null;
        }
        return new Point((int)p2d.x, (int)p2d.y);
    }

    protected abstract void calculateInverseArray();

    protected void clearInverseArray() {
        if (this.invArray == null) {
            this.invArray = new int[this.dstSize.width * this.dstSize.height];
            this.invArrayLon = new double[this.dstSize.width * this.dstSize.height];
            this.invArrayLat = new double[this.dstSize.width * this.dstSize.height];
        }
        for (int j = 0; j < this.dstSize.height; ++j) {
            for (int i = 0; i < this.dstSize.width; ++i) {
                int offset = j * this.dstSize.width + i;
                this.invArray[offset] = -100;
                this.invArrayLon[offset] = Double.NaN;
                this.invArrayLat[offset] = Double.NaN;
            }
        }
    }

    protected static double toDegrees(double d) {
        return d * 57.29577951308232;
    }

    protected static double toRadians(double d) {
        return d * (Math.PI / 180);
    }

    protected Bezier[] makeGridCurves() {
        int i;
        double lastX;
        Vector collect = new Vector(12);
        Vector<Point2D.Double> current = new Vector<Point2D.Double>(100);
        for (int j = -90 + this.gridSpacing; j < 90; j += this.gridSpacing) {
            lastX = 9999.0;
            for (int i2 = (int)(this.cop.x - 180.0); i2 <= (int)(this.cop.x + 180.0); ++i2) {
                Point2D.Double dot = this.transformLL2XY(i2, j);
                if (dot == null) {
                    if (lastX != 9999.0) {
                        collect.add(current);
                        current = new Vector(100);
                    }
                    lastX = 9999.0;
                    continue;
                }
                if (lastX == 9999.0) {
                    collect.add(current);
                    current = new Vector(100);
                    current.add(dot);
                } else if (Math.abs(dot.x - lastX) > Math.abs(dot.x - (double)this.dstCenter.x)) {
                    double dlon = Math.abs((double)i2 - this.cop.x) % 360.0;
                    if (dlon > 90.0 && dlon < 270.0) {
                        Point2D.Double[] mdots = this.findEdgePoints(new Point2D.Double(i2, j), new Point2D.Double(i2 - 5, j));
                        if (mdots[1] != null) {
                            current.add(mdots[1]);
                        }
                        collect.add(current);
                        current = new Vector(100);
                        if (mdots[0] != null) {
                            current.add(mdots[0]);
                        }
                    }
                    current.add(dot);
                } else {
                    current.add(dot);
                }
                lastX = dot.x;
            }
            collect.add(current);
            current = new Vector(100);
        }
        for (i = 0; i < 360; i += this.gridSpacing) {
            if (this.cop.y == 0.0 && Math.abs((this.cop.x - (double)i) % 360.0) == 180.0) continue;
            lastX = 9999.0;
            for (int j = -90; j <= 90; ++j) {
                double lat = j;
                if (j == -90) {
                    lat = -89.5;
                } else if (j == 90) {
                    lat = 89.5;
                }
                Point2D.Double dot = this.transformLL2XY(i, lat);
                if (dot == null || Double.isNaN(dot.x) || Double.isNaN(dot.y)) {
                    if (lastX != 9999.0) {
                        collect.add(current);
                        current = new Vector(100);
                    }
                    lastX = 9999.0;
                    continue;
                }
                if (lastX == 9999.0 || Math.abs(dot.x - lastX) > Math.abs(dot.x - (double)this.dstCenter.x)) {
                    collect.add(current);
                    current = new Vector(100);
                    current.add(dot);
                } else {
                    current.add(dot);
                }
                lastX = dot.x;
            }
            collect.add(current);
            current = new Vector(100);
        }
        for (i = collect.size() - 1; i >= 0; --i) {
            Vector v = (Vector)collect.get(i);
            if (v.size() >= 2) continue;
            collect.remove(i);
        }
        Bezier[] curves = new Bezier[collect.size()];
        for (int i3 = 0; i3 < collect.size(); ++i3) {
            Vector v = (Vector)collect.get(i3);
            Point2D.Double first = (Point2D.Double)v.firstElement();
            Point2D.Double last = (Point2D.Double)v.lastElement();
            curves[i3] = new Bezier(first.x == last.x && first.y == last.y, v);
        }
        return curves;
    }

    private Point2D.Double[] translatePoints(Point2D.Double[] odots) {
        Vector<Point2D.Double> v = new Vector<Point2D.Double>(25000);
        double lastX = 9999.0;
        for (int i = 0; i < odots.length; ++i) {
            double dlon;
            if (odots[i] == null || odots[i].x == 9999.0) {
                if (v.size() > 0 && v.lastElement() != null) {
                    v.add(null);
                }
                lastX = 9999.0;
                continue;
            }
            Point2D.Double dot = this.transformLL2XY(odots[i].x, odots[i].y);
            if (dot == null || Double.isNaN(dot.x) || Double.isNaN(dot.y)) {
                if (v.size() > 0 && v.lastElement() != null) {
                    v.add(null);
                }
                lastX = 9999.0;
                continue;
            }
            if (lastX == 9999.0) {
                v.add(dot);
                lastX = dot.x;
                continue;
            }
            if (Math.abs(dot.x - lastX) > Math.abs(dot.x - (double)this.dstCenter.x) && (dlon = Math.abs(odots[i].x - this.cop.x) % 360.0) > 90.0 && dlon < 270.0) {
                Point2D.Double[] mdots = this.findEdgePoints(odots[i], odots[i - 1]);
                if (mdots[1] != null) {
                    v.add(mdots[1]);
                }
                if (v.size() > 0 && v.lastElement() != null) {
                    v.add(null);
                }
                if (mdots[0] != null) {
                    v.add(mdots[0]);
                    v.add(dot);
                } else {
                    v.add(dot);
                }
                lastX = dot.x;
                continue;
            }
            v.add(dot);
            lastX = dot.x;
        }
        Point2D.Double[] result = new Point2D.Double[v.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Point2D.Double)v.get(i);
        }
        return result;
    }

    private Point2D.Double[] findEdgePoints(Point2D.Double point1, Point2D.Double point2) {
        Point2D.Double dotA = null;
        Point2D.Double dotB = null;
        double leftEdge = this.cop.x - 180.0;
        double rightEdge = this.cop.x + 180.0;
        while (point1.x <= leftEdge) {
            point1.x += 360.0;
        }
        while (point1.x > rightEdge) {
            point1.x -= 360.0;
        }
        while (point2.x <= leftEdge) {
            point2.x += 360.0;
        }
        while (point2.x > rightEdge) {
            point2.x -= 360.0;
        }
        if (Math.abs(point1.x - this.cop.x) > 179.1) {
            if (Math.abs(point2.x - this.cop.x) < 179.1) {
                dotB = point2.x < this.cop.x ? this.transformLL2XY(leftEdge + 0.1, point2.y) : this.transformLL2XY(rightEdge - 0.1, point2.y);
            }
        } else if (point1.x > this.cop.x) {
            if (point1.x < rightEdge - 0.1) {
                dotA = this.transformLL2XY(rightEdge - 0.1, point1.y);
            }
            if (point2.x > leftEdge + 0.1) {
                dotB = this.transformLL2XY(leftEdge + 0.1, point2.y);
            }
        } else {
            if (point1.x > leftEdge + 0.1) {
                dotA = this.transformLL2XY(leftEdge + 0.1, point1.y);
            }
            if (point2.x < rightEdge - 0.1) {
                dotB = this.transformLL2XY(rightEdge - 0.1, point2.y);
            }
        }
        return new Point2D.Double[]{dotA, dotB};
    }
}

