/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.overlay;

import gov.nasa.giss.mapping.overlay.AbstractOverlay;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;

public class OutlineOverlay
extends AbstractOverlay {
    public static final double BAD_POINT = -99999.0;
    private Point2D.Double[] points;
    private GeneralPath path;

    public OutlineOverlay(File f) throws IOException, FileNotFoundException {
        if (f == null) {
            throw new FileNotFoundException("Cannot open nullfile");
        }
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.makeName(f.toURL().toString());
        this.readPath(f);
    }

    public OutlineOverlay(URL url) throws IOException, FileNotFoundException {
        if (url == null) {
            throw new FileNotFoundException("Cannot open null file");
        }
        this.makeName(url.toString());
        this.readPath(url);
    }

    public OutlineOverlay(byte[] bytes, String identifier) throws IOException {
        this.makeName(identifier);
        this.readPath(bytes);
    }

    private void readPath(File f) throws FileNotFoundException, IOException {
        this.readPath(new InputStreamReader(new FileInputStream(f)));
    }

    private void readPath(URL url) throws IOException {
        this.readPath(new InputStreamReader(url.openStream()));
    }

    private void readPath(byte[] bytes) throws IOException {
        this.readPath(new InputStreamReader(new ByteArrayInputStream(bytes)));
    }

    private void readPath(InputStreamReader iStream) throws IOException {
        this.path = new GeneralPath(1, 5000);
        double lastX = -99999.0;
        ArrayList<Point2D.Double> temporary = new ArrayList<Point2D.Double>();
        int lineNo = 0;
        try {
            BufferedReader bStream = new BufferedReader(iStream);
            String aLine = "";
            int capacity = 5000;
            while ((aLine = bStream.readLine()) != null) {
                int commaAt;
                if (lineNo >= capacity - 100) {
                    temporary.ensureCapacity(capacity += 1000);
                }
                if ((commaAt = aLine.indexOf(",")) > -1) {
                    double lon = Double.parseDouble(aLine.substring(0, commaAt));
                    double lat = Double.parseDouble(aLine.substring(commaAt + 1));
                    temporary.add(new Point2D.Double(lon, lat));
                    if (lastX == -99999.0) {
                        this.path.moveTo((float)lon, (float)lat);
                    } else {
                        this.path.lineTo((float)lon, (float)lat);
                    }
                    lastX = lon;
                } else {
                    temporary.add(new Point2D.Double(-99999.0, -99999.0));
                    lastX = -99999.0;
                }
                if (++lineNo < capacity) continue;
                break;
            }
            iStream.close();
        }
        catch (Exception exc) {
            throw new IOException("Bad outline point at line " + ++lineNo);
        }
        if (temporary.size() == 0) {
            throw new IOException("No points in file");
        }
        this.points = temporary.toArray(new Point2D.Double[temporary.size()]);
    }

    public String getName() {
        return super.getName() + " outline";
    }

    public String toString() {
        return this.getName();
    }

    public Point2D.Double[] getPoints() {
        return this.points;
    }

    public GeneralPath getPath() {
        return this.path;
    }
}

