/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.overlay;

import gov.nasa.giss.graphics.filters.MaskFilter;
import gov.nasa.giss.mapping.overlay.AbstractOverlay;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class MaskOverlay
extends AbstractOverlay {
    private static Toolkit toolkit = Toolkit.getDefaultToolkit();
    private static JFrame dummy = new JFrame("MaskOverlay dummy listener");
    private Image source;
    private MediaTracker mTracker;

    public MaskOverlay(File f) throws InterruptedException, IOException, FileNotFoundException {
        if (f == null) {
            throw new FileNotFoundException("Cannot open nullfile");
        }
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.makeName(f.toURL().toString());
        this.initFromLocation(f.toURL());
    }

    public MaskOverlay(URL url) throws InterruptedException, IOException, FileNotFoundException {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        this.makeName(url.toString());
        this.initFromLocation(url);
    }

    public MaskOverlay(byte[] bytes, String id) throws InterruptedException {
        this.identifier = id;
        this.makeName(this.identifier);
        this.mTracker = new MediaTracker(dummy);
        this.source = toolkit.createImage(bytes);
        this.mTracker.addImage(this.source, 0);
        this.mTracker.waitForID(0);
    }

    private void initFromLocation(URL url) throws IllegalArgumentException, InterruptedException, IOException, FileNotFoundException {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        this.source = new ImageIcon(url).getImage();
        if (this.source.getWidth(dummy) < 1 || this.source.getHeight(dummy) < 1) {
            throw new IOException("Invalid image file");
        }
    }

    public String getName() {
        return super.getName() + " mask";
    }

    public String toString() {
        return this.getName();
    }

    public int getWidth(Component observer) {
        return this.source.getWidth(observer);
    }

    public int getHeight(Component observer) {
        return this.source.getHeight(observer);
    }

    public Image getSource() {
        return this.source;
    }

    public Image getMask(Color color) {
        return this.getMask(color, false);
    }

    public Image getMask(Color color, boolean b) {
        FilteredImageSource ip = new FilteredImageSource(this.source.getSource(), new MaskFilter(color, b));
        Image mask = toolkit.createImage(ip);
        this.mTracker = new MediaTracker(dummy);
        this.mTracker.addImage(mask, 4);
        try {
            this.mTracker.waitForID(4);
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
        return mask;
    }
}

