/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.landmarks;

import gov.nasa.giss.mapping.landmarks.Landmark;
import gov.nasa.giss.xml.EasyParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class LandmarkList {
    private ArrayList data = new ArrayList(10);

    public LandmarkList() {
    }

    public LandmarkList(File f) throws FileNotFoundException, IOException, JDOMException {
        this.buildFromStream(new FileInputStream(f));
    }

    public LandmarkList(URL urlBase, String fname) throws IOException, JDOMException, MalformedURLException {
        this(new URL(urlBase, fname));
    }

    public LandmarkList(URL url) throws IOException, JDOMException {
        this.buildFromStream(url.openStream());
    }

    public LandmarkList(InputStream is) throws IOException, JDOMException {
        this.buildFromStream(is);
    }

    private void buildFromStream(InputStream is) throws IOException, JDOMException {
        Document document = EasyParser.parseDocument(is);
        Element root = document.getRootElement();
        if (!root.getName().equals("landmarklist")) {
            throw new IllegalArgumentException("File root element is not 'landmarklist'.");
        }
        Iterator iter = root.getChildren().iterator();
        while (iter.hasNext()) {
            Element child = (Element)iter.next();
            String childName = child.getName();
            if (childName.equals("landmark")) {
                try {
                    this.data.add(new Landmark(child));
                }
                catch (Exception exc) {
                    System.err.println("WARNING: Landmark error : " + exc.toString());
                }
                continue;
            }
            System.err.println("WARNING: Not a landmark node : " + childName);
        }
        Comparator compare = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Landmark)o1).compareTo((Landmark)o2);
            }
        };
        Collections.sort(this.data, compare);
    }

    public int count() {
        return this.data.size();
    }

    public void add(Landmark sat) {
        this.data.add(sat);
    }

    public Landmark get(int index) {
        return (Landmark)this.data.get(index);
    }

    public Landmark findByName(String lname) {
        for (int i = 0; i < this.count(); ++i) {
            Landmark l = (Landmark)this.data.get(i);
            if (lname.indexOf(l.getName()) <= -1) continue;
            return l;
        }
        return null;
    }

    public Landmark findByCode(String lcode) {
        for (int i = 0; i < this.count(); ++i) {
            Landmark l = (Landmark)this.data.get(i);
            if (!lcode.equals(l.getCode())) continue;
            return l;
        }
        return null;
    }
}

