/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.landmarks;

import gov.nasa.giss.mapping.landmarks.LandmarkEvent;
import gov.nasa.giss.mapping.landmarks.LandmarkListener;
import java.awt.Color;
import java.util.Iterator;
import javax.swing.event.EventListenerList;
import org.jdom.Element;

public class Landmark {
    public static final int ACTIVE = 1;
    public static final int PLANNED = 1;
    public static final int LANDER = 3;
    public static final int CRASHSITE = 4;
    public static final int FEATURE = 5;
    public static final int REGION = 6;
    public static final int UNKNOWN = 99;
    private double longitude = Double.NaN;
    private double latitude = Double.NaN;
    private boolean markIt = false;
    private int type = 99;
    private String code;
    private String name;
    private String description;
    private Color color = Color.white;
    protected EventListenerList listenerList = new EventListenerList();

    public Landmark(Element node) {
        Iterator iter = node.getChildren().iterator();
        while (iter.hasNext()) {
            Element child = (Element)iter.next();
            String childName = child.getName();
            if (childName.equals("name")) {
                this.name = child.getText();
                continue;
            }
            if (childName.equals("code")) {
                this.code = child.getText();
                continue;
            }
            if (childName.equals("longitude")) {
                try {
                    this.longitude = Double.parseDouble(child.getText());
                }
                catch (Exception exc) {
                    throw new IllegalArgumentException("Bad data in longitude field");
                }
                while (this.longitude < 0.0) {
                    this.longitude += 360.0;
                }
                this.longitude %= 360.0;
                continue;
            }
            if (childName.equals("latitude")) {
                try {
                    this.latitude = Double.parseDouble(child.getText());
                    continue;
                }
                catch (Exception exc) {
                    throw new IllegalArgumentException("Bad data in latitude field");
                }
            }
            if (childName.equals("type")) {
                String value = child.getText();
                if (value.indexOf("active lander") > -1) {
                    this.type = 1;
                    this.color = Color.cyan;
                    continue;
                }
                if (value.indexOf("planned lander") > -1) {
                    this.type = 1;
                    this.color = Color.white;
                    continue;
                }
                if (value.indexOf("crash site") > -1) {
                    this.type = 4;
                    this.color = Color.red;
                    continue;
                }
                if (value.indexOf("lander") > -1) {
                    this.type = 3;
                    this.color = Color.green;
                    continue;
                }
                if (value.indexOf("surface feature") > -1) {
                    this.type = 5;
                    this.color = Color.yellow;
                    continue;
                }
                if (value.indexOf("region") <= -1) continue;
                this.type = 6;
                this.color = Color.yellow;
                continue;
            }
            if (!childName.equals("notes")) continue;
            this.description = child.getText();
        }
        if (Double.isNaN(this.longitude)) {
            throw new IllegalArgumentException("No data in longitude field");
        }
        if (Double.isNaN(this.latitude)) {
            throw new IllegalArgumentException("No data in latitude field");
        }
        if (this.code == null) {
            this.code = "XXX";
        }
        if (this.name == null) {
            this.name = "Unnamed site";
        }
    }

    public Landmark(int type, double lon, double lat, String code, String name) {
        this(type, lon, lat, code, name, Color.green);
    }

    public Landmark(int type, double lon, double lat, String code, String name, Color color) {
        this.type = type;
        this.longitude = lon;
        this.latitude = lat;
        this.markIt = false;
        this.code = code;
        this.name = name;
        this.color = color;
    }

    public int getType() {
        return this.type;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isMarked() {
        return this.markIt;
    }

    public void setMarked(boolean b) {
        if (b == this.markIt) {
            return;
        }
        this.markIt = b;
        this.fireLandmarkChanged();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        if (c.equals(this.color)) {
            return;
        }
        this.color = c;
        this.fireLandmarkChanged();
    }

    public int compareTo(Landmark other) {
        if (this.type > other.getType()) {
            return 1;
        }
        if (this.type < other.getType()) {
            return -1;
        }
        return this.name.compareTo(other.getName());
    }

    public synchronized void addLandmarkListener(LandmarkListener l) {
        this.listenerList.add(LandmarkListener.class, l);
    }

    public synchronized void removeLandmarkListener(LandmarkListener l) {
        this.listenerList.remove(LandmarkListener.class, l);
    }

    protected void fireLandmarkChanged() {
        LandmarkEvent e = new LandmarkEvent(this, 1);
        Object[] list = this.listenerList.getListenerList();
        for (int i = 0; i < list.length; ++i) {
            if (!(list[i] instanceof LandmarkListener)) continue;
            ((LandmarkListener)list[i]).landmarkChanged(e);
        }
    }
}

