/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping;

import gov.nasa.giss.mapping.MappingConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class DayNightMap
extends Component
implements MappingConstants {
    private static final double UNKNOWN = 9999.0;
    private static final double DEFAULT_SUBSOLAR_LON = 0.0;
    private static final double DEFAULT_SUBSOLAR_LAT = 0.0;
    private static final int transparentRGB = new Color(0, 0, 0, 0).getRGB();
    private Image srcImage;
    private BufferedImage dstImage;
    private BufferedImage shadow;
    private Dimension srcSize = new Dimension(0, 0);
    private Dimension dstSize = new Dimension(0, 0);
    private Dimension shadowArea = new Dimension(0, 0);
    private Dimension shadowAreaP1 = new Dimension(0, 0);
    private int maxOpaque = 153;
    private double maxOpaqueF = this.maxOpaque;
    private double brightCos = 0.2;
    private double pixPerDeg;
    private double degPerPix;
    private int darkSkip;
    private double[] mapLon;
    private double[] mapLat;
    private double[] cosMapColat;
    private double[] sinMapColat;
    private double[][] cosC;
    private double[] cosDTheta;
    private double subsolarLon;
    private double subsolarLat;
    private double cosSubsolarColat;
    private double sinSubsolarColat;
    private boolean needsRedraw = true;

    public DayNightMap(Image img, int dw, int dh) {
        this.setSource(img);
        this.shadowArea.width = 400;
        this.shadowArea.height = this.shadowArea.width / 2;
        this.shadowAreaP1.width = this.shadowArea.width + 1;
        this.shadowAreaP1.height = this.shadowArea.height + 1;
        this.dstSize.width = dw;
        this.dstSize.height = dh;
        this.shadow = new BufferedImage(this.shadowArea.width, this.shadowArea.height, 2);
        this.dstImage = new BufferedImage(this.dstSize.width, this.dstSize.height, 2);
        this.pixPerDeg = (double)this.shadowArea.width / 360.0;
        this.degPerPix = 1.0 / this.pixPerDeg;
        this.darkSkip = this.shadowArea.width / 6;
        this.cosDTheta = new double[this.shadowAreaP1.width];
        this.cosC = new double[this.shadowAreaP1.height][this.shadowAreaP1.width];
        this.mapLon = new double[this.shadowAreaP1.width];
        this.mapLat = new double[this.shadowAreaP1.height];
        this.cosMapColat = new double[this.shadowAreaP1.height];
        this.sinMapColat = new double[this.shadowAreaP1.height];
        for (int i = 0; i < this.shadowAreaP1.width; ++i) {
            this.mapLon[i] = this.degPerPix * (double)i - 180.0;
        }
        for (int j = 0; j < this.shadowAreaP1.height; ++j) {
            double mapColat = this.degPerPix * (double)j;
            this.mapLat[j] = 90.0 - mapColat;
            this.cosMapColat[j] = Math.cos(Math.toRadians(mapColat));
            this.sinMapColat[j] = Math.sin(Math.toRadians(mapColat));
        }
        this.setSubsolarPoint(0.0, 0.0);
    }

    public void setSource(Image img) {
        this.srcImage = img;
        if (this.srcImage == null) {
            this.srcSize.width = 200;
            this.srcSize.height = 100;
        } else {
            this.srcSize.width = this.srcImage.getWidth(this);
            this.srcSize.height = this.srcImage.getHeight(this);
        }
        this.needsRedraw = true;
    }

    public int getDarkness() {
        return this.maxOpaque;
    }

    public void setDarkness(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("Darkness must be in range 0.0 to 1.0.");
        }
        this.setDarkness((int)(value * 255.0));
    }

    public void setDarkness(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Darkness must be in range 0 to 255.");
        }
        this.maxOpaque = value;
        this.maxOpaqueF = this.maxOpaque;
        this.needsRedraw = true;
    }

    public void setSubsolarPoint(double lon, double lat) {
        this.subsolarLon = lon;
        this.subsolarLat = lat;
        this.cosSubsolarColat = Math.cos(Math.toRadians(90.0 - this.subsolarLat));
        this.sinSubsolarColat = Math.sin(Math.toRadians(90.0 - this.subsolarLat));
        this.needsRedraw = true;
    }

    public BufferedImage getMap() {
        if (this.needsRedraw) {
            this.drawTerminator();
            this.needsRedraw = false;
        }
        return this.dstImage;
    }

    private void drawTerminator() {
        int j;
        int i;
        Graphics2D shadowGfx = (Graphics2D)this.shadow.getGraphics();
        for (i = 0; i < this.shadowArea.width; ++i) {
            for (j = 0; j < this.shadowArea.height; ++j) {
                this.shadow.setRGB(i, j, transparentRGB);
            }
        }
        for (i = 0; i < this.shadowAreaP1.width; ++i) {
            this.cosDTheta[i] = 9999.0;
            for (j = 0; j < this.shadowAreaP1.height; ++j) {
                this.cosC[j][i] = 9999.0;
            }
        }
        for (int j2 = 0; j2 < this.shadowArea.height; j2 += this.darkSkip) {
            int jx = j2 + this.darkSkip;
            if (jx > this.shadowArea.height) {
                jx = this.shadowArea.height;
            }
            for (int i2 = 0; i2 < this.shadowArea.width; i2 += this.darkSkip) {
                int ix = i2 + this.darkSkip;
                if (ix > this.shadowArea.width) {
                    ix = this.shadowArea.width;
                }
                this.drawDarkness(shadowGfx, i2, ix, j2, jx);
            }
        }
        shadowGfx.dispose();
        Graphics2D dstGfx = (Graphics2D)this.dstImage.getGraphics();
        if (this.srcImage == null) {
            dstGfx.setColor(new Color(255, 250, 250));
            dstGfx.fillRect(0, 0, this.dstSize.width, this.dstSize.height);
        } else {
            dstGfx.drawImage(this.srcImage, 0, 0, this.dstSize.width, this.dstSize.height, 0, 0, this.srcSize.width, this.srcSize.height, this);
        }
        dstGfx.drawImage(this.shadow, 0, 0, this.dstSize.width, this.dstSize.height, 0, 0, this.shadowArea.width, this.shadowArea.height, this);
        dstGfx.dispose();
        this.needsRedraw = false;
    }

    private void drawDarkness(Graphics2D g, int left, int right, int top, int bottom) {
        if (left < 0 || bottom < 0) {
            return;
        }
        if (right > this.shadowArea.width || bottom > this.shadowArea.height) {
            return;
        }
        int width = right - left;
        int height = bottom - top;
        if (width < 1 || height < 1) {
            return;
        }
        boolean isDark = true;
        double minCos = 1.0;
        for (int k = 0; k < 4; ++k) {
            int jx;
            int ix;
            if (k == 0) {
                ix = left;
                jx = top;
            } else if (k == 1) {
                ix = right;
                jx = top;
            } else if (k == 2) {
                ix = left;
                jx = bottom;
            } else {
                ix = right;
                jx = bottom;
            }
            if (this.cosC[jx][ix] == 9999.0) {
                if (this.cosDTheta[ix] == 9999.0) {
                    this.cosDTheta[ix] = Math.cos(Math.toRadians(this.subsolarLon - this.mapLon[ix]));
                }
                this.cosC[jx][ix] = this.cosSubsolarColat * this.cosMapColat[jx] + this.sinSubsolarColat * this.sinMapColat[jx] * this.cosDTheta[ix];
            }
            if (this.cosC[jx][ix] > 0.0) {
                isDark = false;
            }
            minCos = Math.min(minCos, this.cosC[jx][ix]);
        }
        if (isDark) {
            g.setColor(new Color(0, 0, 0, this.maxOpaque));
            g.fillRect(left, top, width, height);
        } else if (!(minCos > this.brightCos)) {
            int opacity;
            if (minCos > 0.0 && width < 2 && height < 2) {
                opacity = (int)(this.maxOpaqueF * (1.0 - minCos / this.brightCos));
                if (opacity < 0) {
                    opacity = 0;
                } else if (opacity > this.maxOpaque) {
                    opacity = this.maxOpaque;
                }
                g.setColor(new Color(0, 0, 0, opacity));
                g.fillRect(left, top, width, height);
            } else if (width < 2 && height < 2) {
                opacity = (int)(this.maxOpaqueF * (1.0 - minCos / this.brightCos));
                if (opacity < 0) {
                    opacity = 0;
                } else if (opacity > this.maxOpaque) {
                    opacity = this.maxOpaque;
                }
                g.setColor(new Color(0, 0, 0, opacity));
                g.fillRect(left, top, width, height);
            } else if (width < height) {
                int yAve = (top + bottom) / 2;
                this.drawDarkness(g, left, right, top, yAve);
                this.drawDarkness(g, left, right, yAve, bottom);
            } else {
                int xAve = (left + right) / 2;
                this.drawDarkness(g, left, xAve, top, bottom);
                this.drawDarkness(g, xAve, right, top, bottom);
            }
        }
    }
}

