/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.img;

import gov.nasa.giss.img.BitFile;
import gov.nasa.giss.img.LZWStringTable;
import java.io.IOException;
import java.io.OutputStream;

class LZWCompressor {
    LZWCompressor() {
    }

    public static void LZWCompress(OutputStream output, int codesize, byte[] toCompress) throws IOException {
        short prefix = -1;
        BitFile bitFile = new BitFile(output);
        LZWStringTable strings = new LZWStringTable();
        int clearcode = 1 << codesize;
        int endofinfo = clearcode + 1;
        int numbits = codesize + 1;
        int limit = (1 << numbits) - 1;
        strings.ClearTable(codesize);
        bitFile.writeBits(clearcode, numbits);
        for (int loop = 0; loop < toCompress.length; ++loop) {
            byte c = toCompress[loop];
            short index = strings.FindCharString(prefix, c);
            if (index != -1) {
                prefix = index;
                continue;
            }
            bitFile.writeBits(prefix, numbits);
            if (strings.AddCharString(prefix, c) > limit) {
                if (++numbits > 12) {
                    bitFile.writeBits(clearcode, numbits - 1);
                    strings.ClearTable(codesize);
                    numbits = codesize + 1;
                }
                limit = (1 << numbits) - 1;
            }
            prefix = (short)((short)c & 0xFF);
        }
        if (prefix != -1) {
            bitFile.writeBits(prefix, numbits);
        }
        bitFile.writeBits(endofinfo, numbits);
        bitFile.Flush();
    }
}

