/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.img;

import com.jhlabs.image.QuantizeFilter;
import gov.nasa.giss.img.GIF87aEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class GifIO {
    private GifIO() {
    }

    public static void write(BufferedImage img, File f) throws IOException {
        FileOutputStream ostream;
        block8: {
            ostream = new FileOutputStream(f);
            try {
                boolean success = false;
                try {
                    new GIF87aEncoder(img).write(ostream);
                    success = true;
                }
                catch (Exception exc) {
                    success = false;
                }
                if (success) break block8;
                try {
                    int iw = img.getWidth();
                    int ih = img.getHeight();
                    int[] srcPixels = new int[iw * ih];
                    int[] dstPixels = new int[iw * ih];
                    try {
                        new PixelGrabber(img, 0, 0, iw, ih, srcPixels, 0, iw).grabPixels();
                    }
                    catch (Exception exc) {
                        return;
                    }
                    new QuantizeFilter().quantize(srcPixels, dstPixels, iw, ih, 256, false, true);
                    new GIF87aEncoder(dstPixels, iw, ih).write(ostream);
                }
                catch (Exception exc) {
                    System.out.println("ERROR: Unable to save image as GIF.");
                    exc.printStackTrace();
                }
            }
            catch (Exception exc) {
                System.out.println("ERROR: Unable to save image as GIF.");
                exc.printStackTrace();
            }
        }
        ostream.close();
    }
}

