/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.table;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class JTableKeystrokeAdapter {
    private static Clipboard systemClip;
    private JTable table;
    private boolean cutAllowed = false;
    private boolean copyAllowed = true;
    private boolean pasteAllowed = false;
    private boolean selectAllAllowed = true;

    public JTableKeystrokeAdapter(JTable t) {
        this.table = t;
        try {
            systemClip = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Exception exc) {
            return;
        }
        InputMap im = this.table.getInputMap(0);
        ActionMap am = this.table.getActionMap();
        KeyStroke ks = KeyStroke.getKeyStroke("meta X");
        String name = "cut-to-clipboard";
        AbstractAction action = new AbstractAction(name){

            public void actionPerformed(ActionEvent e) {
                if (!JTableKeystrokeAdapter.this.cutAllowed) {
                    return;
                }
                int numcols = JTableKeystrokeAdapter.this.table.getSelectedColumnCount();
                int numrows = JTableKeystrokeAdapter.this.table.getSelectedRowCount();
                if (numcols != 1 || numrows != 1) {
                    return;
                }
            }
        };
        im.put(ks, name);
        am.put(name, action);
        ks = KeyStroke.getKeyStroke("meta C");
        name = "copy-to-clipboard";
        action = new AbstractAction(name){

            public void actionPerformed(ActionEvent e) {
                System.out.println("DEBUG: table copy");
                if (!JTableKeystrokeAdapter.this.copyAllowed) {
                    return;
                }
                StringBuffer sbf = new StringBuffer();
                int numcols = JTableKeystrokeAdapter.this.table.getSelectedColumnCount();
                int numrows = JTableKeystrokeAdapter.this.table.getSelectedRowCount();
                if (numcols == 0 || numrows == 0) {
                    return;
                }
                int[] rSelected = JTableKeystrokeAdapter.this.table.getSelectedRows();
                int[] cSelected = JTableKeystrokeAdapter.this.table.getSelectedColumns();
                if (rSelected.length == 0 || cSelected.length == 0) {
                    return;
                }
                if (numrows - 1 != rSelected[rSelected.length - 1] - rSelected[0] || numrows != rSelected.length || numcols - 1 != cSelected[cSelected.length - 1] - cSelected[0] || numcols != cSelected.length) {
                    return;
                }
                for (int i = 0; i < numrows; ++i) {
                    for (int j = 0; j < numcols; ++j) {
                        sbf.append(JTableKeystrokeAdapter.this.table.getValueAt(rSelected[i], cSelected[j]));
                        if (j >= numcols - 1) continue;
                        sbf.append("\t");
                    }
                    sbf.append("\n");
                }
                StringSelection strSelection = new StringSelection(sbf.toString());
                systemClip = Toolkit.getDefaultToolkit().getSystemClipboard();
                systemClip.setContents(strSelection, strSelection);
            }
        };
        im.put(ks, name);
        am.put(name, action);
        ks = KeyStroke.getKeyStroke("meta V");
        name = "paste-from-clipboard";
        action = new AbstractAction(name){

            public void actionPerformed(ActionEvent e) {
                if (!JTableKeystrokeAdapter.this.pasteAllowed) {
                    return;
                }
                int startRow = JTableKeystrokeAdapter.this.table.getSelectedRows()[0];
                int startCol = JTableKeystrokeAdapter.this.table.getSelectedColumns()[0];
                try {
                    String trstring = (String)systemClip.getContents(this).getTransferData(DataFlavor.stringFlavor);
                    StringTokenizer st1 = new StringTokenizer(trstring, "\n");
                    int i = 0;
                    while (st1.hasMoreTokens()) {
                        String rowstring = st1.nextToken();
                        StringTokenizer st2 = new StringTokenizer(rowstring, "\t");
                        int j = 0;
                        while (st2.hasMoreTokens()) {
                            String value = st2.nextToken();
                            if (startRow + i < JTableKeystrokeAdapter.this.table.getRowCount() && startCol + j < JTableKeystrokeAdapter.this.table.getColumnCount()) {
                                JTableKeystrokeAdapter.this.table.setValueAt(value, startRow + i, startCol + j);
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        };
        im.put(ks, name);
        am.put(name, action);
        ks = KeyStroke.getKeyStroke("meta A");
        name = "select-all";
        action = new AbstractAction(name){

            public void actionPerformed(ActionEvent e) {
                JTableKeystrokeAdapter.this.table.changeSelection(0, 0, false, false);
                JTableKeystrokeAdapter.this.table.addColumnSelectionInterval(0, JTableKeystrokeAdapter.this.table.getColumnCount() - 1);
                JTableKeystrokeAdapter.this.table.addRowSelectionInterval(0, JTableKeystrokeAdapter.this.table.getRowCount() - 1);
            }
        };
        im.put(ks, name);
        am.put(name, action);
    }
}

