/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.filechooser;

import gov.nasa.giss.gui.filechooser.ExtFileFilter;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;

public class SaveFileChooser
extends JFileChooser
implements ActionListener,
DocumentListener,
PropertyChangeListener {
    public static final String DOT_GIF = ".gif";
    public static final String DOT_PDF = ".pdf";
    public static final String DOT_PNG = ".png";
    public static final String DOT_PS = ".ps";
    private static final ExtFileFilter GIF_FILTER = ExtFileFilter.create("gif");
    private static final ExtFileFilter PDF_FILTER = ExtFileFilter.create("pdf");
    private static final ExtFileFilter PNG_FILTER = ExtFileFilter.create("png");
    private static final ExtFileFilter PS_FILTER = ExtFileFilter.create("ps");
    private static final ExtFileFilter[] FILTERS = new ExtFileFilter[]{GIF_FILTER, PDF_FILTER, PNG_FILTER, PS_FILTER};
    private static File recentPath;
    private static String recentFname;
    private JTextField fnameField;
    private Document fnameDocument;
    private boolean directoryJustChanged = false;
    private boolean setTextInProgress = false;

    public SaveFileChooser(File f) {
        this();
        this.setCurrentDirectory(f);
        this.setSelectedFile(f);
        if (f != null && f.isFile()) {
            recentFname = f.getName();
        }
    }

    public SaveFileChooser(String name) {
        this();
        try {
            File f = new File(this.getCurrentDirectory(), name);
            this.setSelectedFile(f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        recentFname = name;
    }

    public SaveFileChooser(File folder, String name) {
        this();
        try {
            File f = new File(folder, name);
            this.setSelectedFile(f);
            recentFname = name;
        }
        catch (Exception exception) {
            // empty catch block
        }
        recentFname = name;
    }

    private SaveFileChooser() {
        this.setDialogType(1);
        this.setDialogTitle("Save plot as\u2026");
        this.setMultiSelectionEnabled(false);
        this.setCurrentDirectory(recentPath);
        this.setAcceptAllFileFilterUsed(false);
        this.addChoosableFileFilter(GIF_FILTER);
        this.addChoosableFileFilter(PDF_FILTER);
        this.addChoosableFileFilter(PNG_FILTER);
        this.addChoosableFileFilter(PS_FILTER);
        this.addPropertyChangeListener(this);
        this.addActionListener(this);
        this.fnameField = (JTextField)this.findTextField(this);
        if (this.fnameField != null) {
            this.fnameDocument = this.fnameField.getDocument();
            this.fnameDocument.addDocumentListener(this);
            this.addPropertyChangeListener(this);
        }
    }

    public void setFileName(String fname) throws IOException {
        if (fname == null) {
            throw new IllegalArgumentException("Filename is null");
        }
        File f = new File(this.getCurrentDirectory(), fname);
        this.setSelectedFile(f);
        String lcname = fname.toLowerCase();
        FileFilter[] filters = this.getChoosableFileFilters();
        for (int i = 0; i < filters.length; ++i) {
            if (!(filters[i] instanceof ExtFileFilter) || !fname.endsWith("." + ((ExtFileFilter)filters[i]).getExtensionLowerCase())) continue;
            this.setFileFilter(filters[i]);
            return;
        }
        if (this.isAcceptAllFileFilterUsed()) {
            this.setFileFilter(this.getAcceptAllFileFilter());
        }
    }

    private Component findTextField(Component c) {
        if (c.getClass() == JTextField.class) {
            return c;
        }
        if (c instanceof Container) {
            Component[] children = ((Container)c).getComponents();
            for (int i = 0; i < children.length; ++i) {
                Component child = this.findTextField(children[i]);
                if (child == null) continue;
                return child;
            }
        }
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ApproveSelection")) {
            recentPath = this.getCurrentDirectory();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        if (this.setTextInProgress) {
            return;
        }
        recentFname = this.fnameField.getText();
    }

    public void insertUpdate(DocumentEvent e) {
        recentFname = this.fnameField.getText();
    }

    public void removeUpdate(DocumentEvent e) {
        if (this.setTextInProgress) {
            return;
        }
        if (this.directoryJustChanged) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SaveFileChooser.this.setTextInProgress = true;
                    SaveFileChooser.this.fnameField.setText(recentFname);
                    SaveFileChooser.this.setTextInProgress = false;
                }
            });
            this.directoryJustChanged = false;
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String pname = e.getPropertyName();
        this.directoryJustChanged = false;
        if (pname.equals("fileFilterChanged")) {
            this.validateExtension();
        } else if (pname.equals("directoryChanged")) {
            this.directoryJustChanged = true;
        }
    }

    private void validateExtension() {
        if (recentFname.lastIndexOf(".") < 1) {
            return;
        }
        FileFilter currentFilter = this.getFileFilter();
        if (this.isAcceptAllFileFilterUsed() && currentFilter.equals(this.getAcceptAllFileFilter())) {
            return;
        }
        for (int i = 0; i < FILTERS.length; ++i) {
            if (!recentFname.toLowerCase().endsWith(FILTERS[i].getExtensionLowerCase())) continue;
            if (currentFilter == FILTERS[i]) {
                return;
            }
            int lastDot = recentFname.lastIndexOf(".");
            for (int j = 0; j < FILTERS.length; ++j) {
                if (currentFilter != FILTERS[j]) continue;
                recentFname = recentFname.substring(0, lastDot + 1) + FILTERS[j].getExtensionLowerCase();
                this.fnameField.setText(recentFname);
                return;
            }
        }
    }

    static {
        recentFname = "Unnamed file";
    }
}

