/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.filechooser;

import java.io.File;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class ExtFileFilter
extends FileFilter {
    public static final String GIF_EXT = "gif";
    public static final String PDF_EXT = "pdf";
    public static final String PNG_EXT = "png";
    public static final String PS_EXT = "ps";
    private static Hashtable filterHash = new Hashtable();
    private String extension;
    private String dotExtension;
    private String description;

    private ExtFileFilter(String e, String d) {
        this.extension = e.toLowerCase();
        this.dotExtension = "." + this.extension;
        this.description = d;
        filterHash.put(this.extension.toLowerCase(), this);
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        return f.getName().toLowerCase().endsWith(this.dotExtension);
    }

    public String getExtensionLowerCase() {
        return this.extension;
    }

    public String getDescription() {
        return this.description;
    }

    public static Object getFilter(String e) {
        return filterHash.get(e.toLowerCase());
    }

    public static ExtFileFilter create(String filtername) {
        if (filtername == null) {
            throw new IllegalArgumentException("Filter ID is null");
        }
        if (ExtFileFilter.getFilter(filtername) != null) {
            return (ExtFileFilter)ExtFileFilter.getFilter(filtername);
        }
        if (filtername.equals(GIF_EXT)) {
            return new ExtFileFilter(GIF_EXT, "GIF (*.gif)");
        }
        if (filtername.equals(PDF_EXT)) {
            return new ExtFileFilter(PDF_EXT, "PDF (*.pdf)");
        }
        if (filtername.equals(PNG_EXT)) {
            return new ExtFileFilter(PNG_EXT, "PNG (*.png)");
        }
        if (filtername.equals(PS_EXT)) {
            return new ExtFileFilter(PS_EXT, "Postscript (*.ps)");
        }
        throw new IllegalArgumentException("Unknown filter ID");
    }

    public static ExtFileFilter create(String filtername, String description) {
        if (filtername == null) {
            throw new IllegalArgumentException("Filter ID is null");
        }
        if (description == null) {
            throw new IllegalArgumentException("Filter description is null");
        }
        if (ExtFileFilter.getFilter(filtername) != null) {
            return (ExtFileFilter)ExtFileFilter.getFilter(filtername);
        }
        return new ExtFileFilter(filtername, description);
    }
}

