/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui;

import gov.nasa.giss.graphics.filters.DarkFilter;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.net.URL;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ToolbarButton
extends JButton {
    private static Toolkit toolkit = Toolkit.getDefaultToolkit();

    public ToolbarButton(ImageIcon icon, String iconText, Action action, String tooltip) {
        int fSize = Math.max(9, this.getFont().getSize() - 2);
        this.setFont(this.getFont().deriveFont((float)fSize));
        this.setAction(action);
        this.setText(null);
        this.setIcon(icon);
        if (icon != null) {
            this.setRolloverEnabled(true);
            Image pImage = toolkit.createImage(new FilteredImageSource(icon.getImage().getSource(), new DarkFilter(33)));
            ImageIcon pIcon = new ImageIcon(pImage);
            this.setSelectedIcon(pIcon);
            this.setPressedIcon(pIcon);
        }
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.setBorder(null);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setMargin(new Insets(4, 4, 4, 4));
        this.setToolTipText(tooltip);
    }

    public ToolbarButton(URL resource, String iconText, Action action, String tooltip) {
        this(new ImageIcon(resource), iconText, action, tooltip);
    }

    public ToolbarButton(Image image, String iconText, Action action, String tooltip) {
        this(new ImageIcon(image), iconText, action, tooltip);
    }
}

