/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import net.schmunk.gui.FlexingGridLayout;

public class SheetableJFrame
extends JFrame
implements ActionListener {
    private static final int INCOMING = 1;
    private static final int OUTGOING = -1;
    private static final float ANIMATION_DURATION = 200.0f;
    private static final int ANIMATION_SLEEP = 10;
    private JComponent sheet;
    private Glass glass = new Glass();
    private AnimatingSheet animatingSheet;
    private boolean animating;
    private int animationDirection;
    private Timer animationTimer;
    private long animationStart;

    public SheetableJFrame(String name) {
        super(name);
        this.setGlassPane(this.glass);
        this.animatingSheet = new AnimatingSheet();
        this.animatingSheet.setBorder(new LineBorder(Color.black, 1));
    }

    public JComponent showJDialogAsSheet(JDialog dialog) {
        this.sheet = (JComponent)dialog.getContentPane();
        this.sheet.setBorder(new LineBorder(Color.black, 1));
        this.glass.removeAll();
        this.startAnimation(1);
        return this.sheet;
    }

    public void hideSheet() {
        this.startAnimation(-1);
    }

    private void startAnimation(int dir) {
        this.animationDirection = dir;
        this.glass.repaint();
        this.animatingSheet.setSource(this.sheet);
        this.glass.addSheet(this.animatingSheet);
        this.animationStart = System.currentTimeMillis();
        if (this.animationTimer == null) {
            this.animationTimer = new Timer(10, this);
        }
        this.animating = true;
        this.animationTimer.start();
    }

    private void stopAnimation() {
        this.animationTimer.stop();
        this.animating = false;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.animating) {
            this.glass.setVisible(true);
            float animationPercent = (float)(System.currentTimeMillis() - this.animationStart) / 200.0f;
            animationPercent = Math.min(1.0f, animationPercent);
            int animatingHeight = 0;
            animatingHeight = this.animationDirection == 1 ? (int)(animationPercent * (float)this.sheet.getHeight()) : (int)((1.0f - animationPercent) * (float)this.sheet.getHeight());
            this.animatingSheet.setAnimatingHeight(animatingHeight);
            this.animatingSheet.repaint();
            if (animationPercent >= 1.0f) {
                this.stopAnimation();
                if (this.animationDirection == 1) {
                    this.finishShowingSheet();
                } else {
                    this.glass.removeAll();
                    this.glass.setVisible(false);
                }
            }
        }
    }

    private void finishShowingSheet() {
        this.glass.removeAll();
        this.glass.addSheet(this.sheet);
    }

    class Glass
    extends JPanel
    implements MouseListener {
        Glass() {
            FlexingGridLayout fgl = new FlexingGridLayout(new Dimension(3, 2));
            fgl.setColumnWeight(0, 9999.0f);
            fgl.setColumnWeight(2, 9999.0f);
            fgl.setRowWeight(1, 9999.0f);
            this.setLayout(fgl);
            this.setOpaque(true);
            this.addMouseListener(this);
        }

        private void addSheet(JComponent jc) {
            this.removeAll();
            this.add(Box.createGlue(), new Rectangle(0, 0, 1, 1));
            this.add(Box.createGlue(), new Rectangle(2, 0, 1, 1));
            this.add(Box.createGlue(), new Rectangle(1, 1, 1, 1));
            this.add((Component)jc, new Rectangle(1, 0, 1, 1));
            this.setVisible(true);
            this.revalidate();
            this.repaint();
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void paintComponent(Graphics g) {
            SheetableJFrame.this.getContentPane().paint(g);
        }
    }

    class AnimatingSheet
    extends JPanel {
        Dimension animatingSize = new Dimension(0, 1);
        JComponent source;
        BufferedImage offscreenImage;

        public AnimatingSheet() {
            this.setOpaque(true);
        }

        public void setSource(JComponent source) {
            this.source = source;
            this.animatingSize.width = source.getWidth();
            this.makeOffscreenImage(source);
        }

        public void setAnimatingHeight(int height) {
            this.animatingSize.height = height;
            this.setSize(this.animatingSize);
        }

        private void makeOffscreenImage(JComponent source) {
            GraphicsConfiguration gfxConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.offscreenImage = gfxConfig.createCompatibleImage(source.getWidth(), source.getHeight());
            Graphics2D offscreenGraphics = (Graphics2D)this.offscreenImage.getGraphics();
            source.paint(offscreenGraphics);
        }

        public Dimension getPreferredSize() {
            return this.animatingSize;
        }

        public Dimension getMinimumSize() {
            return this.animatingSize;
        }

        public Dimension getMaximumSize() {
            return this.animatingSize;
        }

        public void paint(Graphics g) {
            BufferedImage fragment = this.offscreenImage.getSubimage(0, this.offscreenImage.getHeight() - this.animatingSize.height, this.source.getWidth(), this.animatingSize.height);
            g.drawImage(fragment, 0, 0, this);
        }
    }
}

