/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui;

import java.awt.Component;
import javax.swing.Box;
import javax.swing.SwingConstants;

public class QuickBox
extends Box
implements SwingConstants {
    public static final int NONE = 0;

    private QuickBox(int axis) {
        super(axis);
    }

    private QuickBox(int axis, Component[] components) {
        this(axis);
        for (int i = 0; i < components.length; ++i) {
            this.add(components[i]);
        }
    }

    private QuickBox(int axis, int alignment, Component[] components) {
        this(axis);
        if (axis == 0) {
            if (alignment == 4 || alignment == 0) {
                this.add(Box.createHorizontalGlue());
            }
        } else if (axis == 1 && (alignment == 1 || alignment == 0)) {
            this.add(Box.createHorizontalGlue());
        }
        for (int i = 0; i < components.length; ++i) {
            this.add(components[i]);
        }
        if (axis == 0) {
            if (alignment == 2 || alignment == 0) {
                this.add(Box.createHorizontalGlue());
            }
        } else if (axis == 1 && (alignment == 3 || alignment == 0)) {
            this.add(Box.createHorizontalGlue());
        }
    }

    public static QuickBox createHorizontalBox(Component[] components) {
        return new QuickBox(0, components);
    }

    public static QuickBox createHorizontalBox(int alignment, Component[] components) {
        if (alignment != 2 && alignment != 0 && alignment != 4 && alignment != 0) {
            throw new IllegalArgumentException("Illegal horizontal alignment");
        }
        return new QuickBox(0, alignment, components);
    }

    public static QuickBox createVerticalBox(Component[] components) {
        return new QuickBox(1, components);
    }

    public static QuickBox createVerticalBox(int alignment, Component[] components) {
        if (alignment != 1 && alignment != 0 && alignment != 3 && alignment != 0) {
            throw new IllegalArgumentException("Illegal horizontal alignment");
        }
        return new QuickBox(1, alignment, components);
    }
}

