/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui;

import java.util.Hashtable;
import javax.swing.KeyStroke;

public class CommonShortcuts {
    public static final String QUIT_NAME = "Quit";
    public static final String NEW_NAME = "New";
    public static final String OPEN_NAME = "Open\u2026";
    public static final String CLOSE_NAME = "Close";
    public static final String SAVE_NAME = "Save";
    public static final String SAVEAS_NAME = "Save As\u2026";
    public static final String PAGESETUP_NAME = "Page Setup\u2026";
    public static final String PRINT_NAME = "Print\u2026";
    public static final String UNDO_NAME = "Undo";
    public static final String REDO_NAME = "Redo";
    public static final String EDIT_NAME = "Edit";
    public static final String CUT_NAME = "Cut";
    public static final String COPY_NAME = "Copy";
    public static final String PASTE_NAME = "Paste";
    public static final String SELECTALL_NAME = "Select All";
    public static final String CLEAR_NAME = "Clear";
    public static final String MINIMIZE_NAME = "Minimize";
    public static final String PREFERENCES_NAME = "Preferences\u2026";
    private static Hashtable keystrokesHash = new Hashtable();

    public static KeyStroke get(String name) {
        try {
            return (KeyStroke)keystrokesHash.get(name.toLowerCase());
        }
        catch (Exception exc) {
            return null;
        }
    }

    static {
        keystrokesHash.put(QUIT_NAME.toLowerCase(), KeyStroke.getKeyStroke("meta Q"));
        keystrokesHash.put(NEW_NAME.toLowerCase(), KeyStroke.getKeyStroke("meta N"));
        keystrokesHash.put(OPEN_NAME.toLowerCase(), KeyStroke.getKeyStroke("meta O"));
        keystrokesHash.put(CLOSE_NAME.toLowerCase(), KeyStroke.getKeyStroke("meta W"));
        keystrokesHash.put(SAVE_NAME.toLowerCase(), KeyStroke.getKeyStroke("meta S"));
        keystrokesHash.put(SAVEAS_NAME.toLowerCase(), KeyStroke.getKeyStroke("meta shift S"));
        keystrokesHash.put(PAGESETUP_NAME.toLowerCase(), KeyStroke.getKeyStroke("meta shift P"));
        keystrokesHash.put(PRINT_NAME.toLowerCase(), KeyStroke.getKeyStroke("meta P"));
        keystrokesHash.put(UNDO_NAME.toLowerCase(), KeyStroke.getKeyStroke("meta Z"));
        keystrokesHash.put(REDO_NAME.toLowerCase(), KeyStroke.getKeyStroke("meta shift Z"));
        keystrokesHash.put(COPY_NAME.toLowerCase(), KeyStroke.getKeyStroke("meta C"));
        keystrokesHash.put(CUT_NAME.toLowerCase(), KeyStroke.getKeyStroke("meta X"));
        keystrokesHash.put(PASTE_NAME.toLowerCase(), KeyStroke.getKeyStroke("meta V"));
        keystrokesHash.put(SELECTALL_NAME.toLowerCase(), KeyStroke.getKeyStroke("meta A"));
        try {
            if (System.getProperty("mrj.version") != null) {
                keystrokesHash.put(MINIMIZE_NAME.toLowerCase(), KeyStroke.getKeyStroke("meta M"));
            } else {
                keystrokesHash.put(PREFERENCES_NAME.toLowerCase(), KeyStroke.getKeyStroke("meta K"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

