/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui;

import gov.nasa.giss.gui.border.CheckBoxBorder;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class CheckBoxBorderPanel
extends JPanel {
    private JCheckBox checkbox;
    private JPanel content;

    public CheckBoxBorderPanel(JCheckBox jcb) {
        this(jcb, null);
    }

    public CheckBoxBorderPanel(JCheckBox jcb, JPanel jp) {
        if (jcb == null) {
            throw new IllegalArgumentException("Checkbox cannot be null.");
        }
        this.checkbox = jcb;
        this.content = jp == null ? new JPanel() : jp;
        this.setBorder(new CheckBoxBorder(this.checkbox));
        this.setLayout(null);
        super.add(jcb);
        super.add(this.content);
    }

    public JCheckBox getCheckBox() {
        return this.checkbox;
    }

    public JPanel getContentPanel() {
        return this.content;
    }

    public void validate() {
        Insets ins = this.getInsets();
        this.content.setBounds(ins.left, ins.top, this.getSize().width - ins.left - ins.right, this.getSize().height - ins.top - ins.bottom);
        super.validate();
    }

    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        return new Dimension(this.content.getPreferredSize().width + ins.left + ins.right, this.content.getPreferredSize().height + ins.top + ins.bottom);
    }
}

