/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.ps;

import gov.nasa.giss.graphics.ps.PsDocument;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PsGraphics2D
extends Graphics2D {
    private static final NumberFormat DFORMAT = NumberFormat.getNumberInstance();
    private static final int FILL = 1;
    private static final int STROKE = 2;
    private static final int CLIP = 3;
    private static final AffineTransform IDENTITY = new AffineTransform();
    public static int AFM_DIVISOR = 1000;
    private PsDocument _document;
    private boolean _textAsCurves = false;
    private float _width;
    private float _height;
    private BasicStroke strokeOne = new BasicStroke(1.0f);
    private Stroke stroke;
    private Stroke originalStroke;
    private Stroke oldStroke;
    private Font font;
    private float fontSize;
    private AffineTransform _transform;
    private Paint paint;
    private Paint paintFill;
    private Paint paintStroke;
    private Color background;
    private Area clip;
    private RenderingHints rhints = new RenderingHints(null);
    private boolean disposeCalled = false;
    private ArrayList children;
    private boolean child = false;
    private Graphics dummyGfx = new BufferedImage(2, 2, 1).getGraphics();
    private MediaTracker mediaTracker;
    private boolean underline;
    private int currentFillGState = 255;
    private int currentStrokeGState = 255;

    private PsGraphics2D() {
    }

    protected PsGraphics2D(PsDocument document, float width, float height, boolean textAsCurves) {
        this._document = document;
        this._width = width;
        this._height = height;
        this._textAsCurves = textAsCurves;
        this._transform = new AffineTransform();
        this.children = new ArrayList();
        this.paint = Color.black;
        this.background = Color.white;
        this.setFont(new Font("sanserif", 0, 12));
        this.clip = new Area(new Rectangle2D.Float(0.0f, 0.0f, this._width, this._height));
        this.clip(this.clip);
        this.originalStroke = this.strokeOne;
        this.stroke = this.strokeOne;
        this.oldStroke = this.strokeOne;
        this.setStrokeDiff(this.stroke, null);
    }

    public void draw(Shape s) {
        this.drawPath(s, 2);
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        AffineTransform oldAT = this.getTransform();
        this.transform(xform);
        boolean result = this.drawImage(img, 0, 0, obs);
        this.setTransform(oldAT);
        return result;
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.drawImage(op.filter(img, null), new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null);
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        BufferedImage image = null;
        if (img instanceof BufferedImage) {
            image = (BufferedImage)img;
        } else {
            ColorModel cm = img.getColorModel();
            int w = img.getWidth();
            int h = img.getHeight();
            WritableRaster raster = cm.createCompatibleWritableRaster(w, h);
            boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            String[] keys = img.getPropertyNames();
            if (keys != null) {
                for (int i = 0; i < keys.length; ++i) {
                    properties.put(keys[i], img.getProperty(keys[i]));
                }
            }
            BufferedImage result = new BufferedImage(cm, raster, isAlphaPremultiplied, properties);
            img.copyData(raster);
            image = result;
        }
        this.drawImage(image, xform, null);
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.drawRenderedImage(img.createDefaultRendering(), xform);
    }

    public void drawString(String s, int x, int y) {
        this.drawString(s, (float)x, (float)y);
    }

    public static double asPoints(double d, int i) {
        return d * (double)i / (double)AFM_DIVISOR;
    }

    protected void doAttributes(AttributedCharacterIterator iter) {
        this.underline = false;
        Set<AttributedCharacterIterator.Attribute> set = iter.getAttributes().keySet();
        Iterator<AttributedCharacterIterator.Attribute> iterator = set.iterator();
        while (iterator.hasNext()) {
            TextAttribute textattribute = (TextAttribute)iterator.next();
            if (textattribute.equals(TextAttribute.FONT)) {
                Font font = (Font)iter.getAttributes().get(textattribute);
                this.setFont(font);
                continue;
            }
            if (textattribute.equals(TextAttribute.UNDERLINE)) {
                if (iter.getAttributes().get(textattribute) != TextAttribute.UNDERLINE_ON) continue;
                this.underline = true;
                continue;
            }
            if (textattribute.equals(TextAttribute.SUPERSCRIPT)) continue;
            if (textattribute.equals(TextAttribute.SIZE)) {
                Object obj = iter.getAttributes().get(textattribute);
                Font font1 = null;
                if (obj instanceof Integer) {
                    int i = (Integer)obj;
                    font1 = this.getFont().deriveFont(this.getFont().getStyle(), i);
                } else if (obj instanceof Float) {
                    float f = ((Float)obj).floatValue();
                    font1 = this.getFont().deriveFont(this.getFont().getStyle(), f);
                } else {
                    return;
                }
                this.setFont(font1);
                continue;
            }
            String s = "only FONT/SIZE/UNDERLINE/SUPERSCRIPT supported";
            throw new RuntimeException(s);
        }
    }

    public void drawString(String s, float x, float y) {
        if (s == null || s.length() == 0) {
            return;
        }
        this.setFillPaint();
        if (this._textAsCurves) {
            GlyphVector gv = this.getFont().createGlyphVector(this.getFontRenderContext(), s.toCharArray());
            this.drawGlyphVector(gv, x, y);
        } else {
            Point2D.Float p1 = new Point2D.Float(x, y);
            Point2D.Float p2 = new Point2D.Float(0.0f, 0.0f);
            this._transform.transform(p1, p2);
            StringBuffer sb = new StringBuffer(s);
            for (int i = sb.length() - 1; i >= 0; --i) {
                if (sb.charAt(i) != '\\' && sb.charAt(i) != '(' && sb.charAt(i) != ')' && sb.charAt(i) != '<' && sb.charAt(i) != '>' && sb.charAt(i) != '[' && sb.charAt(i) != ']' && sb.charAt(i) != '{' && sb.charAt(i) != '}' && sb.charAt(i) != '%') continue;
                sb.insert(i, '\\');
            }
            float scale = (float)Math.sqrt(Math.abs(this._transform.getDeterminant()));
            this.psPrintln("/" + this.font.getPSName() + " findfont");
            this.psPrintln(p2.x + " " + this.normalizeY(p2.y) + " moveto");
            this.psPrintln((float)this.font.getSize() * scale + " scalefont setfont");
            this.psPrintln("(" + sb.toString() + ") show");
            if (this.underline) {
                // empty if block
            }
        }
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    public void drawString(AttributedCharacterIterator iter, float x, float y) {
        StringBuffer stringbuffer = new StringBuffer(iter.getEndIndex());
        char c = iter.first();
        while (c != '\uffff') {
            if (iter.getIndex() == iter.getRunStart()) {
                if (stringbuffer.length() > 0) {
                    this.drawString(stringbuffer.toString(), x, y);
                    FontMetrics fontmetrics = this.getFontMetrics();
                    x = (float)((double)x + fontmetrics.getStringBounds(stringbuffer.toString(), this).getWidth());
                    stringbuffer.delete(0, stringbuffer.length());
                }
                this.doAttributes(iter);
            }
            stringbuffer.append(c);
            c = iter.next();
        }
        this.drawString(stringbuffer.toString(), x, y);
        this.underline = false;
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
        Shape s = g.getOutline(x, y);
        this.fill(s);
    }

    public void fill(Shape s) {
        this.drawPath(s, 1);
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (onStroke) {
            s = this.stroke.createStrokedShape(s);
        }
        s = this._transform.createTransformedShape(s);
        Area area = new Area(s);
        if (this.clip != null) {
            area.intersect(this.clip);
        }
        return area.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return ((Graphics2D)this.dummyGfx).getDeviceConfiguration();
    }

    public void setComposite(Composite comp) {
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        this.paint = paint;
        if (paint instanceof Color) {
            this.psSetRgbColor((Color)paint);
        }
    }

    private Stroke transformStroke(Stroke stroke) {
        if (!(stroke instanceof BasicStroke)) {
            return stroke;
        }
        BasicStroke st = (BasicStroke)stroke;
        float scale = (float)Math.sqrt(Math.abs(this._transform.getDeterminant()));
        float[] dash = st.getDashArray();
        if (dash != null) {
            int k = 0;
            while (k < dash.length) {
                int n = k++;
                dash[n] = dash[n] * scale;
            }
        }
        return new BasicStroke(st.getLineWidth() * scale, st.getEndCap(), st.getLineJoin(), st.getMiterLimit(), dash, st.getDashPhase() * scale);
    }

    private void setStrokeDiff(Stroke newStroke, Stroke oldStroke) {
        if (newStroke == oldStroke) {
            return;
        }
        if (!(newStroke instanceof BasicStroke)) {
            return;
        }
        BasicStroke nStroke = (BasicStroke)newStroke;
        boolean oldOk = oldStroke instanceof BasicStroke;
        BasicStroke oStroke = null;
        if (oldOk) {
            oStroke = (BasicStroke)oldStroke;
        }
        if (!oldOk || nStroke.getLineWidth() != oStroke.getLineWidth()) {
            this.psPrintln(nStroke.getLineWidth() + " setlinewidth");
        }
        if (!oldOk || nStroke.getEndCap() != oStroke.getEndCap()) {
            switch (nStroke.getEndCap()) {
                case 0: {
                    this.psPrintln("0 setlinecap");
                    break;
                }
                case 2: {
                    this.psPrintln("2 setlinecap");
                    break;
                }
                default: {
                    this.psPrintln("1 setlinecap");
                }
            }
        }
        if (!oldOk || nStroke.getLineJoin() != oStroke.getLineJoin()) {
            switch (nStroke.getLineJoin()) {
                case 0: {
                    this.psPrintln("0 setlinejoin");
                    break;
                }
                case 2: {
                    this.psPrintln("2 setlinejoin");
                    break;
                }
                default: {
                    this.psPrintln("1 setlinejoin");
                }
            }
        }
        if (!oldOk || nStroke.getMiterLimit() != oStroke.getMiterLimit()) {
            this.psPrintln(nStroke.getMiterLimit() + " setmiterlimit");
        }
        if (oldOk) {
            if (nStroke.getDashArray() != null) {
                if (nStroke.getDashPhase() != oStroke.getDashPhase()) {
                    boolean makeDash = true;
                } else if (!Arrays.equals(nStroke.getDashArray(), oStroke.getDashArray())) {
                    boolean makeDash = true;
                } else {
                    boolean makeDash = false;
                }
            } else if (oStroke.getDashArray() != null) {
                boolean makeDash = true;
            } else {
                boolean makeDash = false;
            }
        } else {
            boolean makeDash = true;
        }
    }

    public void setStroke(Stroke s) {
        this.originalStroke = s;
        this.stroke = this.transformStroke(s);
    }

    public void setRenderingHint(RenderingHints.Key arg0, Object arg1) {
        try {
            this.rhints.put(arg0, arg1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getRenderingHint(RenderingHints.Key arg0) {
        return this.rhints.get(arg0);
    }

    public void setRenderingHints(Map hints) {
        this.rhints.clear();
        this.rhints.putAll((Map<?, ?>)hints);
    }

    public void addRenderingHints(Map hints) {
        this.rhints.putAll((Map<?, ?>)hints);
    }

    public RenderingHints getRenderingHints() {
        return this.rhints;
    }

    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    public void translate(double tx, double ty) {
        this._transform.translate(tx, ty);
    }

    public void rotate(double theta) {
        this._transform.rotate(theta);
    }

    public void rotate(double theta, double x, double y) {
        this._transform.rotate(theta, x, y);
    }

    public void scale(double sx, double sy) {
        this._transform.scale(sx, sy);
        this.stroke = this.transformStroke(this.originalStroke);
    }

    public void shear(double shx, double shy) {
        this._transform.shear(shx, shy);
    }

    public void transform(AffineTransform tx) {
        this._transform.concatenate(tx);
        this.stroke = this.transformStroke(this.originalStroke);
    }

    public void setTransform(AffineTransform t) {
        this._transform = new AffineTransform(t);
        this.stroke = this.transformStroke(this.originalStroke);
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this._transform);
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Composite getComposite() {
        return null;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public Stroke getStroke() {
        return this.originalStroke;
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(null, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graphics create() {
        PsGraphics2D g2 = new PsGraphics2D();
        g2._document = this._document;
        g2._textAsCurves = this._textAsCurves;
        g2._transform = new AffineTransform(this._transform);
        g2.children = this.children;
        g2.paint = this.paint;
        g2.background = this.background;
        g2.mediaTracker = this.mediaTracker;
        g2.setFont(this.font);
        g2._width = this._width;
        g2._height = this._height;
        g2.drawPath(new Area(new Rectangle2D.Float(0.0f, 0.0f, this._width, this._height)), 3);
        if (this.clip != null) {
            g2.clip = new Area(this.clip);
        }
        g2.stroke = this.stroke;
        g2.originalStroke = this.originalStroke;
        g2.strokeOne = (BasicStroke)g2.transformStroke(g2.strokeOne);
        g2.oldStroke = g2.strokeOne;
        g2.setStrokeDiff(g2.oldStroke, null);
        if (g2.clip != null) {
            g2.drawPath(g2.clip, 3);
        }
        g2.child = true;
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            this.children.add(g2);
        }
        return g2;
    }

    public Color getColor() {
        if (this.paint instanceof Color) {
            return (Color)this.paint;
        }
        return Color.black;
    }

    public void setColor(Color color) {
        this.setPaint(color);
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color c1) {
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font f) {
        if (f == null) {
            f = Font.decode(null);
        }
        this.font = f;
    }

    public FontMetrics getFontMetrics(Font f) {
        return this.dummyGfx.getFontMetrics(f);
    }

    public Rectangle getClipBounds() {
        if (this.clip == null) {
            return null;
        }
        return this.getClip().getBounds();
    }

    public void clipRect(int x, int y, int width, int height) {
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, width, height);
        this.clip(rect);
    }

    public void setClip(int x, int y, int width, int height) {
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, width, height);
        this.setClip(rect);
    }

    public void clip(Shape s) {
        if (s != null) {
            s = this._transform.createTransformedShape(s);
        }
        if (this.clip == null) {
            this.clip = new Area(s);
        } else {
            this.clip.intersect(new Area(s));
        }
        this.drawPath(s, 3);
    }

    public Shape getClip() {
        try {
            return this._transform.createInverse().createTransformedShape(this.clip);
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
    }

    public void setClip(Shape s) {
        if (s != null) {
            s = this._transform.createTransformedShape(s);
        }
        if (s == null) {
            this.clip = null;
        } else {
            this.clip = new Area(s);
            this.drawPath(s, 3);
        }
        this.paintFill = null;
        this.paintStroke = null;
        this.currentStrokeGState = 255;
        this.currentFillGState = 255;
        this.oldStroke = this.strokeOne;
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        this.draw(line);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.draw(new Rectangle(x, y, width, height));
    }

    public void fillRect(int x, int y, int width, int height) {
        this.fill(new Rectangle(x, y, width, height));
    }

    public void clearRect(int x, int y, int width, int height) {
        Paint temp = this.paint;
        this.setPaint(this.background);
        this.fillRect(x, y, width, height);
        this.setPaint(temp);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    public void drawOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Float(x, y, width, height));
    }

    public void fillOval(int x, int y, int width, int height) {
        this.fill(new Ellipse2D.Float(x, y, width, height));
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0));
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 2));
    }

    public void drawPolyline(int[] x, int[] y, int nPoints) {
        Line2D.Double line = new Line2D.Double(x[0], y[0], x[0], y[0]);
        for (int i = 1; i < nPoints; ++i) {
            ((Line2D)line).setLine(((Line2D)line).getX2(), ((Line2D)line).getY2(), x[i], y[i]);
            this.draw(line);
        }
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon poly = new Polygon();
        for (int i = 0; i < nPoints; ++i) {
            poly.addPoint(xPoints[i], yPoints[i]);
        }
        this.draw(poly);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon poly = new Polygon();
        for (int i = 0; i < nPoints; ++i) {
            poly.addPoint(xPoints[i], yPoints[i]);
        }
        this.fill(poly);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver obs) {
        return this.drawImage(img, x, y, null, obs);
    }

    public boolean drawImage(Image img, int x, int y, int w, int h, ImageObserver obs) {
        return this.drawImage(img, x, y, w, h, null, obs);
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver obs) {
        this.waitForImage(img);
        return this.drawImage(img, x, y, img.getWidth(obs), img.getHeight(obs), bgcolor, obs);
    }

    public boolean drawImage(Image img, int x, int y, int w, int h, Color bgcolor, ImageObserver obs) {
        this.waitForImage(img);
        return this.drawImage(img, x, y, x + w, y + h, 0, 0, w, h, bgcolor, obs);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver obs) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, obs);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver obs) {
        if (dx1 >= dx2) {
            throw new IllegalArgumentException("dx1 >= dx2");
        }
        if (sx1 >= sx2) {
            throw new IllegalArgumentException("sx1 >= sx2");
        }
        if (dy1 >= dy2) {
            throw new IllegalArgumentException("dy1 >= dy2");
        }
        if (sy1 >= sy2) {
            throw new IllegalArgumentException("sy1 >= sy2");
        }
        this.waitForImage(img);
        double dw = dx2 - dx1;
        double dh = dy2 - dy1;
        double sw = sx2 - sx1;
        double sh = sy2 - sy1;
        if (dw == 0.0 || dh == 0.0 || sw == 0.0 || sh == 0.0) {
            return true;
        }
        this.psPrintln("gsave");
        this.psPrint(sw);
        this.psPrint(" ");
        this.psPrint(sh);
        this.psPrintln(" 8");
        AffineTransform xform = new AffineTransform(this._transform);
        xform.translate(dx1, dy1);
        xform.scale(dw / sw, dh / sh);
        double matrixTransX = -xform.getTranslateX();
        double matrixTransY = this.normalizeY(xform.getTranslateY());
        double matrixScaleX = 1.0 / xform.getScaleX();
        double matrixScaleY = 1.0 / xform.getScaleY();
        this.psPrint("[");
        this.psPrint(matrixScaleX);
        this.psPrint(" ");
        this.psPrint(0.0);
        this.psPrint(" ");
        this.psPrint(0.0);
        this.psPrint(" ");
        this.psPrint(-matrixScaleY);
        this.psPrint(" ");
        this.psPrint(matrixTransX * matrixScaleX);
        this.psPrint(" ");
        this.psPrint(matrixTransY * matrixScaleY);
        this.psPrintln("]");
        this.psPrint("{currentfile 3 ");
        this.psPrint(sw);
        this.psPrintln(" mul string readhexstring pop} bind false 3 colorimage");
        try {
            int w = img.getWidth(obs);
            int h = img.getHeight(obs);
            int[] srcPixels = new int[w * h];
            PixelGrabber grabber = new PixelGrabber(img, 0, 0, w, h, srcPixels, 0, w);
            try {
                grabber.grabPixels();
            }
            catch (Exception exc) {
                System.out.println("ERROR: PsGraphics2D drawImage : " + exc.toString());
                return false;
            }
            int offset = 0;
            int rowOffset = 0;
            for (int j = sy1; j < sy2; ++j) {
                rowOffset = j * w;
                for (int i = sx1; i < sx2; ++i) {
                    offset = rowOffset + i;
                    int rgb = srcPixels[offset];
                    int red = rgb >> 16 & 0xFF;
                    int green = rgb >> 8 & 0xFF;
                    int blue = rgb & 0xFF;
                    this.psPrint(this.toHexString(red));
                    this.psPrint(this.toHexString(green));
                    this.psPrint(this.toHexString(blue));
                    if ((offset + 1) % 12 != 0) continue;
                    this.psPrintln("");
                }
            }
            this.psPrintln("");
        }
        catch (Exception exc) {
            System.out.println("ERROR: PsGraphics2D drawImage : " + exc.toString());
            return false;
        }
        this.psPrintln("grestore");
        return true;
    }

    public void dispose() {
        if (this.child) {
            return;
        }
        if (!this.disposeCalled) {
            this.disposeCalled = true;
            for (int k = 0; k < this.children.size(); ++k) {
                PsGraphics2D psGraphics2D = (PsGraphics2D)this.children.get(k);
            }
        }
    }

    private void drawPath(Shape s, int drawType) {
        if (s == null) {
            return;
        }
        if (drawType == 3) {
            return;
        }
        if (drawType == 2 && !(this.stroke instanceof BasicStroke)) {
            s = this.stroke.createStrokedShape(s);
            this.drawPath(s, 1);
            return;
        }
        if (drawType == 2) {
            this.setStrokeDiff(this.stroke, this.oldStroke);
            this.oldStroke = this.stroke;
            this.setStrokePaint();
        } else if (drawType == 1) {
            // empty if block
        }
        PathIterator points = s.getPathIterator(this._transform);
        float[] coords = new float[6];
        int traces = 0;
        Point2D.Float lastPt = new Point2D.Float(0.0f, 0.0f);
        while (!points.isDone()) {
            ++traces;
            int segtype = points.currentSegment(coords);
            this.normalizeY(coords);
            switch (segtype) {
                case 4: {
                    this.psPrintln("closepath");
                    break;
                }
                case 3: {
                    this.psPrint(coords[0]);
                    this.psPrint(" ");
                    this.psPrint(coords[1]);
                    this.psPrint(" ");
                    this.psPrint(coords[2]);
                    this.psPrint(" ");
                    this.psPrint(coords[3]);
                    this.psPrint(" ");
                    this.psPrint(coords[4]);
                    this.psPrint(" ");
                    this.psPrint(coords[5]);
                    this.psPrintln(" curveto");
                    lastPt.x = coords[4];
                    lastPt.y = coords[5];
                    break;
                }
                case 1: {
                    this.psPrint(coords[0]);
                    this.psPrint(" ");
                    this.psPrint(coords[1]);
                    this.psPrintln(" lineto");
                    lastPt.x = coords[0];
                    lastPt.y = coords[1];
                    break;
                }
                case 0: {
                    this.psPrint(coords[0]);
                    this.psPrint(" ");
                    this.psPrint(coords[1]);
                    this.psPrintln(" moveto");
                    lastPt.x = coords[0];
                    lastPt.y = coords[1];
                    break;
                }
                case 2: {
                    float cubicC1x = lastPt.x + 0.6666667f * (coords[0] - lastPt.x);
                    float cubicC1y = lastPt.y + 0.6666667f * (coords[1] - lastPt.y);
                    float cubicC2x = cubicC1x + 0.33333334f * (coords[2] - lastPt.x);
                    float cubicC2y = cubicC1y + 0.33333334f * (coords[3] - lastPt.y);
                    this.psPrint(cubicC1x);
                    this.psPrint(" ");
                    this.psPrint(cubicC1y);
                    this.psPrint(" ");
                    this.psPrint(cubicC2x);
                    this.psPrint(" ");
                    this.psPrint(cubicC2y);
                    this.psPrint(" ");
                    this.psPrint(coords[2]);
                    this.psPrint(" ");
                    this.psPrint(coords[3]);
                    this.psPrintln("  curveto");
                    lastPt.x = coords[2];
                    lastPt.y = coords[3];
                }
            }
            points.next();
        }
        switch (drawType) {
            case 1: {
                if (traces <= 0) break;
                if (points.getWindingRule() == 0) {
                    this.psPrintln("eofill");
                    break;
                }
                this.psPrintln("fill");
                break;
            }
            case 2: {
                if (traces <= 0) break;
                this.psPrintln("stroke");
                break;
            }
            default: {
                if (points.getWindingRule() == 0) {
                    this.psPrintln("eoclip");
                } else {
                    this.psPrintln("clip");
                }
                this.psPrintln("newpath");
            }
        }
    }

    private float normalizeY(float y) {
        return this._height - y;
    }

    private float normalizeY(double y) {
        return (float)((double)this._height - y);
    }

    private void normalizeY(float[] coords) {
        coords[1] = this.normalizeY(coords[1]);
        coords[3] = this.normalizeY(coords[3]);
        coords[5] = this.normalizeY(coords[5]);
    }

    private AffineTransform normalizeMatrix() {
        double[] mx = new double[6];
        AffineTransform result = AffineTransform.getTranslateInstance(0.0, 0.0);
        result.getMatrix(mx);
        mx[3] = -1.0;
        mx[5] = this._height;
        result = new AffineTransform(mx);
        result.concatenate(this._transform);
        return result;
    }

    private boolean checkNewPaint(Paint oldPaint) {
        if (this.paint == oldPaint) {
            return false;
        }
        return !(this.paint instanceof Color) || !this.paint.equals(oldPaint);
    }

    private void setFillPaint() {
        if (this.checkNewPaint(this.paintFill)) {
            this.paintFill = this.paint;
            this.setPaint(false, 0.0, 0.0, true);
        }
    }

    private void setStrokePaint() {
        if (this.checkNewPaint(this.paintStroke)) {
            this.paintStroke = this.paint;
            this.setPaint(false, 0.0, 0.0, false);
        }
    }

    private void setPaint(boolean invert, double xoffset, double yoffset, boolean fill) {
        if (this.paint instanceof Color) {
            Color color = (Color)this.paint;
            int alpha = color.getAlpha();
            if (fill) {
                this.psSetRgbColor(color);
            } else {
                this.psSetRgbColor(color);
            }
        }
    }

    private synchronized void waitForImage(Image image) {
        if (this.mediaTracker == null) {
            this.mediaTracker = new MediaTracker(new fakeComponent());
        }
        this.mediaTracker.addImage(image, 0);
        try {
            this.mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mediaTracker.removeImage(image);
    }

    private String toHexString(int i) {
        String result = Integer.toString(i, 16);
        while (result.length() < 2) {
            result = "0" + result;
        }
        return result;
    }

    private void psSetRgbColor(Color c) {
        this.psPrint((double)c.getRed() / 255.0);
        this.psPrint(" ");
        this.psPrint((double)c.getGreen() / 255.0);
        this.psPrint(" ");
        this.psPrint((double)c.getBlue() / 255.0);
        this.psPrintln(" setrgbcolor");
    }

    private void psPrint(float f) {
        this.psPrint((double)f);
    }

    private void psPrint(double d) {
        this._document.psPrint(DFORMAT.format(d));
    }

    private void psPrint(int i) {
        this._document.psPrint(Integer.toString(i));
    }

    private void psPrint(String s) {
        if (this._document != null) {
            this._document.psPrint(s);
        }
    }

    private void psPrintln(String s) {
        if (this._document != null) {
            this._document.psPrintln(s);
        }
    }

    static {
        DFORMAT.setMinimumFractionDigits(0);
        DFORMAT.setMaximumFractionDigits(5);
        DFORMAT.setGroupingUsed(false);
    }

    private static class fakeComponent
    extends Component {
        private fakeComponent() {
        }
    }
}

