/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.filters;

import java.awt.image.RGBImageFilter;

public class DarkFilter
extends RGBImageFilter {
    private int darkness;

    public DarkFilter(int d) {
        if (d < 0 || d > 100) {
            throw new IllegalArgumentException("Darkness must be an integer of 0-100");
        }
        this.darkness = d;
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int x, int y, int rgb) {
        if (x == -1) {
            // empty if block
        }
        int r = (int)((double)(this.darkness * (rgb & 0xFF0000) / 65536) / 100.0);
        int g = (int)((double)(this.darkness * (rgb & 0xFF00) / 256) / 100.0);
        int b = (int)((double)(this.darkness * (rgb & 0xFF)) / 100.0);
        return rgb & 0xFF000000 | r * 65536 | g * 256 | b;
    }
}

