/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colorbar;

import gov.nasa.giss.graphics.colorbar.AbstractColorbar;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class PALColorbar
extends AbstractColorbar {
    public static final int GRAYSCALE = 1;
    public static final int BLUESCALE = 2;
    public static final int HOTSTREAK = 3;
    public static final int OLDGLORY = 4;
    public static final int GAEA = 5;
    public static final int CHRISTMAS = 6;
    public static final int HOTMETAL = 7;

    public PALColorbar() {
        this.colors = new Color[256];
        this.colorCount = 256;
        this.minBin = 0;
        this.maxBin = 255;
        this.minOutlierBin = this.minBin;
        this.maxOutlierBin = this.maxBin;
        for (int i = 0; i < this.colorCount; ++i) {
            float bright = (float)i / (float)(this.colorCount - 1);
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setName("untitled");
        this.setType("PAL");
    }

    public PALColorbar(File f) throws IOException, FileNotFoundException {
        super(f, 768, 768);
    }

    public PALColorbar(URL url) throws IOException, FileNotFoundException {
        super(url, 768, 768);
    }

    public PALColorbar(byte[] b) throws IOException {
        super(b);
        this.setName("untitled");
        this.setType("PAL");
    }

    public static PALColorbar getPreset(int preset) throws IOException {
        PALColorbar c = new PALColorbar();
        switch (preset) {
            case 1: {
                for (int i = 0; i < 256; ++i) {
                    c.setBin(i, new Color(i, i, i));
                }
                c.setName("grayscale");
                break;
            }
            case 2: {
                for (int i = 0; i < 256; ++i) {
                    c.setBin(i, new Color(i, i, 255));
                }
                c.setName("bluescale");
                break;
            }
            case 3: {
                int i;
                for (i = 0; i < 128; ++i) {
                    c.setBin(i, new Color(255, i * 2, 0));
                }
                for (i = 128; i < 256; ++i) {
                    c.setBin(i, new Color(255, 255, i * 2 - 256));
                }
                c.setName("hotstreak");
                break;
            }
            case 4: {
                int blue;
                int green;
                int red;
                int i;
                for (i = 0; i < 128; ++i) {
                    red = 255;
                    blue = green = i * 2;
                    c.setBin(i, new Color(red, green, blue));
                }
                for (i = 128; i < 256; ++i) {
                    green = red = 511 - 2 * i;
                    blue = 255;
                    c.setBin(i, new Color(red, green, blue));
                }
                c.setName("oldglory");
                break;
            }
            case 5: {
                for (int i = 0; i < 256; ++i) {
                    int blue;
                    int green;
                    int red;
                    if (i < 128) {
                        green = red = i * 2;
                        blue = 153 + i;
                    } else {
                        red = 511 - 2 * i;
                        green = 408 - i;
                        blue = red;
                    }
                    if (blue > 255) {
                        blue = 255;
                    }
                    if (green > 255) {
                        green = 255;
                    }
                    c.setBin(i, new Color(red, green, blue));
                }
                c.setName("gaea");
                break;
            }
            case 6: {
                for (int i = 0; i < 256; ++i) {
                    int blue;
                    int green;
                    int red;
                    if (i < 128) {
                        red = i * 2;
                        green = 153 + i;
                        blue = 51 + i * 2;
                    } else {
                        red = 255;
                        blue = green = 511 - 2 * i;
                    }
                    if (red > 255) {
                        red = 255;
                    }
                    if (green > 255) {
                        green = 255;
                    }
                    if (blue > 255) {
                        blue = 255;
                    }
                    c.setBin(i, new Color(red, green, blue));
                }
                c.setName("christmas");
                break;
            }
            case 7: {
                for (int i = 0; i < 256; ++i) {
                    int blue;
                    int green;
                    int red;
                    if (i < 128) {
                        red = i * 2;
                        green = 0;
                        blue = 0;
                    } else {
                        red = 255;
                        green = (i - 127) * 2;
                        blue = 0;
                    }
                    if (red > 255) {
                        red = 255;
                    }
                    if (green > 255) {
                        green = 255;
                    }
                    if (blue > 255) {
                        blue = 255;
                    }
                    c.setBin(i, new Color(red, green, blue));
                }
                c.setName("hotmetal");
            }
        }
        c.setType("PAL");
        return c;
    }

    public AbstractColorbar copy() throws IOException {
        PALColorbar c = new PALColorbar(this.getBytes());
        c.setName("Copy of " + this.getName());
        return c;
    }

    public byte[] getBytes() {
        byte[] b = new byte[768];
        for (int i = 0; i < this.colorCount; ++i) {
            Color c = this.getColorAt(i);
            b[0 + i] = (byte)c.getRed();
            b[256 + i] = (byte)c.getGreen();
            b[512 + i] = (byte)c.getBlue();
        }
        return b;
    }

    protected void fillColorTable(byte[] b) throws IOException {
        if (b.length < 768) {
            throw new IOException("Not a valid PAL color table");
        }
        this.colorCount = 256;
        this.minBin = 0;
        this.maxBin = 255;
        this.minOutlierBin = this.minBin;
        this.maxOutlierBin = this.maxBin;
        this.colors = new Color[this.colorCount];
        for (int i = 0; i < 256; ++i) {
            this.setBin(i, new Color(0xFF & b[i], 0xFF & b[i + 256], 0xFF & b[i + 512]));
        }
    }

    public String toString() {
        return this.getName() + " PAL";
    }
}

