/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colorbar;

import gov.nasa.giss.graphics.colorbar.AbstractColorbar;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class PAL2Colorbar
extends AbstractColorbar {
    public PAL2Colorbar(File f) throws IOException, FileNotFoundException {
        super(f, 768, 768);
    }

    public PAL2Colorbar(URL url) throws IOException, FileNotFoundException {
        super(url, 768, 768);
    }

    public PAL2Colorbar(byte[] b) throws IOException {
        super(b);
        this.setName("untitled");
        this.setType("PA2");
    }

    public AbstractColorbar copy() throws IOException {
        PAL2Colorbar c = new PAL2Colorbar(this.getBytes());
        c.setName("Copy of " + this.getName());
        return c;
    }

    public byte[] getBytes() {
        byte[] b = new byte[768];
        b[1] = 0;
        b[257] = 0;
        b[513] = 0;
        b[1] = (byte)this.getMinOutlierColor().getRed();
        b[257] = (byte)this.getMinOutlierColor().getGreen();
        b[513] = (byte)this.getMinOutlierColor().getBlue();
        b[254] = (byte)this.getMaxOutlierColor().getRed();
        b[510] = (byte)this.getMaxOutlierColor().getGreen();
        b[766] = (byte)this.getMaxOutlierColor().getBlue();
        b[255] = -1;
        b[511] = -1;
        b[767] = -1;
        for (int i = 0; i < this.colorCount; ++i) {
            Color c = this.getColorAt(i);
            b[2 + i] = (byte)c.getRed();
            b[258 + i] = (byte)c.getGreen();
            b[514 + i] = (byte)c.getBlue();
        }
        return b;
    }

    protected void fillColorTable(byte[] b) throws IOException {
        if (b.length < 768) {
            throw new IOException("Not a valid PAL-2 color table");
        }
        this.colors = new Color[256];
        this.colorCount = 252;
        this.minBin = 2;
        this.maxBin = 253;
        this.minOutlierBin = 1;
        this.maxOutlierBin = 254;
        for (int i = 0; i < 256; ++i) {
            this.setBin(i, new Color(0xFF & b[i], 0xFF & b[i + 256], 0xFF & b[i + 512]));
        }
    }

    public String toString() {
        return this.getName() + " PAL-2";
    }

    public boolean hasSpecialOutliers() {
        return true;
    }
}

